/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tenant;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.tenant.TenantService;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.TenantConstants;
import org.eclipse.hono.util.TenantResult;

public abstract class BaseTenantService<T>
extends EventBusService<T>
implements TenantService {
    @Override
    protected final String getEventBusAddress() {
        return "tenant.in";
    }

    @Override
    public final Future<EventBusMessage> processRequest(EventBusMessage request) {
        Objects.requireNonNull(request);
        switch (TenantConstants.TenantAction.from((String)request.getOperation())) {
            case add: {
                return this.processAddRequest(request);
            }
            case get: {
                return this.processGetRequest(request);
            }
            case update: {
                return this.processUpdateRequest(request);
            }
            case remove: {
                return this.processRemoveRequest(request);
            }
        }
        return this.processCustomTenantMessage(request);
    }

    private Future<EventBusMessage> processGetRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        JsonObject payload = request.getJsonPayload();
        if (tenantId == null && payload == null) {
            this.log.debug("request does not contain any query parameters");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (tenantId != null) {
            this.log.debug("retrieving tenant [{}] using deprecated variant of get tenant request", (Object)tenantId);
            return this.processGetByIdRequest(request, tenantId);
        }
        String tenantIdFromPayload = (String)this.getTypesafeValueForField(payload, "tenant-id");
        String subjectDn = (String)this.getTypesafeValueForField(payload, "subject-dn");
        if (tenantIdFromPayload == null && subjectDn == null) {
            this.log.debug("payload does not contain any query parameters");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (tenantIdFromPayload != null) {
            this.log.debug("retrieving tenant [id: {}]", (Object)tenantIdFromPayload);
            return this.processGetByIdRequest(request, tenantIdFromPayload);
        }
        return this.processGetByCaRequest(request, subjectDn);
    }

    private Future<EventBusMessage> processGetByIdRequest(EventBusMessage request, String tenantId) {
        Future getResult = Future.future();
        this.get(tenantId, (Handler<AsyncResult<TenantResult<JsonObject>>>)getResult.completer());
        return getResult.map(tr -> request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setTenant(tenantId).setCacheDirective(tr.getCacheDirective()));
    }

    private Future<EventBusMessage> processGetByCaRequest(EventBusMessage request, String subjectDn) {
        try {
            X500Principal dn = new X500Principal(subjectDn);
            this.log.debug("retrieving tenant [subject DN: {}]", (Object)subjectDn);
            Future getResult = Future.future();
            this.get(dn, (Handler<AsyncResult<TenantResult<JsonObject>>>)getResult.completer());
            return getResult.map(tr -> {
                EventBusMessage response = request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setCacheDirective(tr.getCacheDirective());
                if (tr.isOk() && tr.getPayload() != null) {
                    response.setTenant((String)this.getTypesafeValueForField((JsonObject)tr.getPayload(), "tenant-id"));
                }
                return response;
            });
        }
        catch (IllegalArgumentException e) {
            this.log.debug("cannot parse subject DN [{}] provided by client", (Object)subjectDn);
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
    }

    private Future<EventBusMessage> processAddRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        JsonObject payload = this.getRequestPayload(request.getJsonPayload());
        if (tenantId == null) {
            this.log.debug("request does not contain mandatory property [{}]", (Object)"tenant_id");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (this.isValidRequestPayload(payload)) {
            this.log.debug("creating tenant [{}]", (Object)tenantId);
            Future addResult = Future.future();
            this.addNotPresentFieldsWithDefaultValuesForTenant(payload);
            this.add(tenantId, payload, (Handler<AsyncResult<TenantResult<JsonObject>>>)addResult.completer());
            return addResult.map(tr -> request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setCacheDirective(tr.getCacheDirective()));
        }
        this.log.debug("request contains malformed payload");
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    private Future<EventBusMessage> processUpdateRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        JsonObject payload = this.getRequestPayload(request.getJsonPayload());
        if (tenantId == null) {
            this.log.debug("request does not contain mandatory property [{}]", (Object)"tenant_id");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (this.isValidRequestPayload(payload)) {
            this.log.debug("updating tenant [{}]", (Object)tenantId);
            Future updateResult = Future.future();
            this.addNotPresentFieldsWithDefaultValuesForTenant(payload);
            this.update(tenantId, payload, (Handler<AsyncResult<TenantResult<JsonObject>>>)updateResult.completer());
            return updateResult.map(tr -> request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setCacheDirective(tr.getCacheDirective()));
        }
        this.log.debug("request contains malformed payload");
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    private Future<EventBusMessage> processRemoveRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        if (tenantId == null) {
            this.log.debug("request does not contain mandatory property [{}]", (Object)"tenant_id");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("deleting tenant [{}]", (Object)tenantId);
        Future removeResult = Future.future();
        this.remove(tenantId, (Handler<AsyncResult<TenantResult<JsonObject>>>)removeResult.completer());
        return removeResult.map(tr -> request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setCacheDirective(tr.getCacheDirective()));
    }

    protected Future<EventBusMessage> processCustomTenantMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    private boolean isValidRequestPayload(JsonObject payload) {
        Object adaptersObj = payload.getValue("adapters");
        if (adaptersObj == null) {
            return true;
        }
        if (adaptersObj instanceof JsonArray) {
            JsonArray adapters = (JsonArray)adaptersObj;
            if (adapters.size() == 0) {
                return false;
            }
            return !adapters.stream().anyMatch(obj -> !(obj instanceof JsonObject) || !((JsonObject)obj).containsKey("type"));
        }
        return false;
    }

    protected final void addNotPresentFieldsWithDefaultValuesForTenant(JsonObject checkedPayload) {
        JsonArray adapters;
        if (!checkedPayload.containsKey("enabled")) {
            this.log.trace("adding 'enabled' key to payload");
            checkedPayload.put("enabled", Boolean.TRUE);
        }
        if ((adapters = checkedPayload.getJsonArray("adapters")) != null) {
            adapters.forEach(elem -> this.addNotPresentFieldsWithDefaultValuesForAdapter((JsonObject)elem));
        }
    }

    private void addNotPresentFieldsWithDefaultValuesForAdapter(JsonObject adapter) {
        if (!adapter.containsKey("enabled")) {
            this.log.trace("adding 'enabled' key to payload");
            adapter.put("enabled", Boolean.TRUE);
        }
        if (!adapter.containsKey("device-authentication-required")) {
            this.log.trace("adding 'device-authentication-required' key to adapter payload");
            adapter.put("device-authentication-required", Boolean.TRUE);
        }
    }

    @Override
    public void get(String tenantId, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void get(X500Principal subjectDn, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void add(String tenantId, JsonObject tenantObj, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void update(String tenantId, JsonObject tenantObj, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void remove(String tenantId, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    protected void handleUnimplementedOperation(Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        resultHandler.handle((Object)Future.failedFuture((Throwable)new ServerErrorException(501)));
    }
}

