/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.metric;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.ext.dropwizard.DropwizardMetricsOptions;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MetricConfig {
    private static final String HONO = "hono";
    private static final String UNKNOWN = "unknown";
    private static final Logger LOG = LoggerFactory.getLogger(MetricConfig.class);
    private String prefix = "hono";
    private final MetricRegistry metricRegistry;

    public MetricConfig(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Bean
    @ConditionalOnProperty(prefix="hono.metric.jvm", name={"memory"}, havingValue="true")
    public MemoryUsageGaugeSet jvmMetricsMemory() {
        LOG.info("metrics - jvm/memory activated");
        return (MemoryUsageGaugeSet)this.metricRegistry.register(this.prefix + ".jvm.memory", (Metric)new MemoryUsageGaugeSet());
    }

    @Bean
    @ConditionalOnProperty(prefix="hono.metric.jvm", name={"thread"}, havingValue="true")
    public ThreadStatesGaugeSet jvmMetricsThreads() {
        LOG.info("metrics - jvm/threads activated");
        return (ThreadStatesGaugeSet)this.metricRegistry.register(this.prefix + ".jvm.thread", (Metric)new ThreadStatesGaugeSet());
    }

    @Bean
    @ConditionalOnProperty(prefix="hono.metric", name={"vertx"}, havingValue="true")
    public MetricsOptions vertxMetricsOptions() {
        LOG.info("metrics - vertx activated");
        SharedMetricRegistries.add((String)HONO, (MetricRegistry)this.metricRegistry);
        SharedMetricRegistries.setDefault((String)HONO, (MetricRegistry)this.metricRegistry);
        return new DropwizardMetricsOptions().setEnabled(true).setRegistryName(HONO).setBaseName(this.prefix + ".vertx").setJmxEnabled(true);
    }

    @Bean
    @ConditionalOnProperty(prefix="hono.metric.reporter.console", name={"active"}, havingValue="true")
    public ConsoleReporter consoleMetricReporter(@Value(value="${hono.metric.reporter.console.period:5000}") Long period) {
        LOG.info("metrics - console reporter activated");
        ConsoleReporter consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build();
        consoleReporter.start(period.longValue(), TimeUnit.MILLISECONDS);
        return consoleReporter;
    }

    @Bean
    @ConditionalOnProperty(prefix="hono.metric.reporter.graphite", name={"active"}, havingValue="true")
    public GraphiteReporter graphiteReporter(@Value(value="${hono.metric.reporter.graphite.period:5000}") Long period, @Value(value="${hono.metric.reporter.graphite.host:localhost}") String host, @Value(value="${hono.metric.reporter.graphite.port:2003}") Integer port, @Value(value="${hono.metric.reporter.graphite.prefix:}") String prefix) {
        Graphite graphite = new Graphite(new InetSocketAddress(host, (int)port));
        String processedPrefix = prefix;
        if (processedPrefix.isEmpty()) {
            try {
                processedPrefix = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException exception) {
                processedPrefix = UNKNOWN;
            }
        }
        LOG.info("metrics - graphite reporter activated: {}:{}  prefix: {}  period: {}", new Object[]{host, port, processedPrefix, period});
        GraphiteReporter reporter = GraphiteReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).prefixedWith(processedPrefix).build(graphite);
        reporter.start(period.longValue(), TimeUnit.MILLISECONDS);
        return reporter;
    }
}

