/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.command;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonDelivery;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.MessageConsumer;
import org.eclipse.hono.client.MessageSender;
import org.eclipse.hono.client.impl.HonoClientImpl;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.service.command.CommandConnection;
import org.eclipse.hono.service.command.CommandConsumer;
import org.eclipse.hono.service.command.CommandResponseSender;
import org.eclipse.hono.service.command.CommandResponseSenderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandConnectionImpl
extends HonoClientImpl
implements CommandConnection {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public CommandConnectionImpl(Vertx vertx, ClientConfigProperties clientConfigProperties) {
        super(vertx, clientConfigProperties);
    }

    @Override
    public final Future<MessageConsumer> createCommandConsumer(String tenantId, String deviceId, BiConsumer<ProtonDelivery, Message> commandConsumer, Handler<Void> closeHandler) {
        return this.createConsumer(tenantId, () -> this.newCommandConsumer(tenantId, deviceId, commandConsumer, closeHandler));
    }

    private Future<MessageConsumer> newCommandConsumer(String tenantId, String deviceId, BiConsumer<ProtonDelivery, Message> messageConsumer, Handler<Void> closeHandler) {
        return this.checkConnected().compose(con -> {
            Future result = Future.future();
            CommandConsumer.create(this.context, this.clientConfigProperties, this.connection, tenantId, deviceId, messageConsumer, (Handler<String>)((Handler)closeHook -> closeHandler.handle(null)), (Handler<AsyncResult<MessageConsumer>>)result.completer());
            return result;
        });
    }

    @Override
    public Future<CommandResponseSender> getOrCreateCommandResponseSender(String tenantId, String deviceId, String replyId) {
        Objects.requireNonNull(tenantId);
        Future result = Future.future();
        this.getOrCreateSender(CommandResponseSenderImpl.getTargetAddress(tenantId, deviceId, replyId), () -> this.createCommandResponseSender(tenantId, deviceId, replyId)).setHandler(h -> {
            if (h.succeeded()) {
                result.complete((Object)((CommandResponseSender)h.result()));
            } else {
                result.fail(h.cause());
            }
        });
        return result;
    }

    private Future<MessageSender> createCommandResponseSender(String tenantId, String deviceId, String replyId) {
        return this.checkConnected().compose(connected -> {
            Future result = Future.future();
            CommandResponseSenderImpl.create(this.context, this.clientConfigProperties, this.connection, tenantId, deviceId, replyId, (Handler<String>)((Handler)onSenderClosed -> this.activeSenders.remove(CommandResponseSenderImpl.getTargetAddress(tenantId, deviceId, replyId))), (Handler<AsyncResult<MessageSender>>)result.completer());
            return result;
        });
    }
}

