/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.delegating;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.impl.VertxInternal;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import java.util.Objects;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.client.impl.AuthenticationServerClient;
import org.eclipse.hono.connection.ConnectionFactory;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.auth.AbstractHonoAuthenticationService;
import org.eclipse.hono.service.auth.delegating.AuthenticationServerClientConfigProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!authentication-impl"})
public class DelegatingAuthenticationService
extends AbstractHonoAuthenticationService<AuthenticationServerClientConfigProperties>
implements HealthCheckProvider {
    private AuthenticationServerClient client;
    private ConnectionFactory factory;
    private DnsClient dnsClient;

    @Autowired
    public void setConfig(AuthenticationServerClientConfigProperties configuration) {
        this.setSpecificConfig((Object)configuration);
    }

    @Autowired(required=false)
    public void setDnsClient(DnsClient dnsClient) {
        this.dnsClient = Objects.requireNonNull(dnsClient);
    }

    @Autowired
    public void setConnectionFactory(@Qualifier(value="authentication") ConnectionFactory connectionFactory) {
        this.factory = Objects.requireNonNull(connectionFactory);
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        if (this.dnsClient != null) {
            this.log.info("registering readiness check using DNS Client");
            readinessHandler.register("authentication-service-availability", status -> {
                this.log.trace("checking availability of Authentication service");
                this.dnsClient.lookup(((AuthenticationServerClientConfigProperties)((Object)((Object)this.getConfig()))).getHost(), lookupAttempt -> {
                    if (lookupAttempt.succeeded()) {
                        status.tryComplete((Object)Status.OK());
                    } else {
                        this.log.debug("readiness check failed to resolve Authentication service address [{}]: ", (Object)((AuthenticationServerClientConfigProperties)((Object)((Object)((Object)this.getConfig())))).getHost(), (Object)lookupAttempt.cause().getMessage());
                        status.tryComplete((Object)Status.KO());
                    }
                });
            });
        } else if (VertxInternal.class.isInstance(this.vertx)) {
            this.log.info("registering readiness check using vert.x Address Resolver");
            readinessHandler.register("authentication-service-availability", status -> {
                this.log.trace("checking availability of Authentication service");
                ((VertxInternal)this.vertx).resolveAddress(((AuthenticationServerClientConfigProperties)((Object)((Object)this.getConfig()))).getHost(), lookupAttempt -> {
                    if (lookupAttempt.succeeded()) {
                        status.tryComplete((Object)Status.OK());
                    } else {
                        this.log.debug("readiness check failed to resolve Authentication service address [{}]: ", (Object)((AuthenticationServerClientConfigProperties)((Object)((Object)((Object)this.getConfig())))).getHost(), (Object)lookupAttempt.cause().getMessage());
                        status.tryComplete((Object)Status.KO());
                    }
                });
            });
        } else {
            this.log.warn("cannot register readiness check, no DNS resolver available");
        }
    }

    @Override
    protected void doStart(Future<Void> startFuture) {
        if (this.factory == null) {
            startFuture.fail("no connection factory for Authentication service set");
        } else {
            this.client = new AuthenticationServerClient(this.vertx, this.factory);
            startFuture.complete();
        }
    }

    @Override
    public void verifyExternal(String authzid, String subjectDn, Handler<AsyncResult<HonoUser>> authenticationResultHandler) {
        this.client.verifyExternal(authzid, subjectDn, authenticationResultHandler);
    }

    @Override
    public void verifyPlain(String authzid, String authcid, String password, Handler<AsyncResult<HonoUser>> authenticationResultHandler) {
        this.client.verifyPlain(authzid, authcid, password, authenticationResultHandler);
    }

    @Override
    public String toString() {
        return DelegatingAuthenticationService.class.getSimpleName() + "[Authentication service: " + ((AuthenticationServerClientConfigProperties)((Object)this.getConfig())).getHost() + ":" + ((AuthenticationServerClientConfigProperties)((Object)this.getConfig())).getPort() + "]";
    }
}

