/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.core.Vertx;
import io.vertx.core.net.TrustOptions;
import java.util.Objects;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.service.auth.HonoTrustManagerFactory;
import org.eclipse.hono.service.auth.TenantApiBasedX509TrustManager;
import org.springframework.beans.factory.annotation.Autowired;

public class TenantApiTrustOptions
implements TrustOptions {
    private final HonoTrustManagerFactory factory;

    private TenantApiTrustOptions(HonoTrustManagerFactory factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    public TenantApiTrustOptions(@Autowired HonoClient client) {
        this(new HonoTrustManagerFactory(new TenantApiBasedX509TrustManager(Objects.requireNonNull(client))));
    }

    public TrustOptions clone() {
        return new TenantApiTrustOptions(this.factory);
    }

    public TrustManagerFactory getTrustManagerFactory(Vertx vertx) {
        return this.factory;
    }
}

