/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.web.Router;
import java.util.Objects;
import org.eclipse.hono.config.ApplicationConfigProperties;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HealthCheckServer
implements Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckServer.class);
    private static final String URI_LIVENESS_PROBE = "/liveness";
    private static final String URI_READINESS_PROBE = "/readiness";
    private HttpServer server;
    private HealthCheckHandler readinessHandler;
    private HealthCheckHandler livenessHandler;
    private Vertx vertx;
    private ApplicationConfigProperties config;
    private Router router;

    public HealthCheckServer(Vertx vertx, ApplicationConfigProperties config) {
        this.vertx = Objects.requireNonNull(vertx);
        this.config = Objects.requireNonNull(config);
        this.prepareHealthCheck();
    }

    private void prepareHealthCheck() {
        if (this.config.getHealthCheckPort() != -1) {
            this.readinessHandler = HealthCheckHandler.create((Vertx)this.vertx);
            this.livenessHandler = HealthCheckHandler.create((Vertx)this.vertx);
            this.router = Router.router((Vertx)this.vertx);
            LOG.debug("Health check prepared.");
        } else {
            LOG.info("No health check configured.");
        }
    }

    public void registerHealthCheckResources(HealthCheckProvider serviceInstance) {
        if (this.router != null) {
            serviceInstance.registerLivenessChecks(this.livenessHandler);
            serviceInstance.registerReadinessChecks(this.readinessHandler);
        }
    }

    @Override
    public Future<Void> start() {
        Future result = Future.future();
        if (this.router != null) {
            HttpServerOptions options = new HttpServerOptions().setPort(this.config.getHealthCheckPort()).setHost(this.config.getHealthCheckBindAddress());
            this.server = this.vertx.createHttpServer(options);
            this.router.get(URI_READINESS_PROBE).handler((Handler)this.readinessHandler);
            this.router.get(URI_LIVENESS_PROBE).handler((Handler)this.livenessHandler);
            this.server.requestHandler(arg_0 -> ((Router)this.router).accept(arg_0)).listen(startAttempt -> {
                if (startAttempt.succeeded()) {
                    LOG.info("readiness probe available at http://{}:{}{}", new Object[]{options.getHost(), options.getPort(), URI_READINESS_PROBE});
                    LOG.info("liveness probe available at http://{}:{}{}", new Object[]{options.getHost(), options.getPort(), URI_LIVENESS_PROBE});
                    result.complete();
                } else {
                    LOG.warn("failed to start health checks HTTP server:", (Object)startAttempt.cause().getMessage());
                    result.fail(startAttempt.cause());
                }
            });
        } else {
            result.complete();
        }
        return result;
    }

    @Override
    public Future<Void> stop() {
        Future result = Future.future();
        if (this.server != null) {
            LOG.info("closing health check HTTP server [{}:{}]", (Object)this.config.getHealthCheckBindAddress(), (Object)this.server.actualPort());
            this.server.close(result.completer());
        } else {
            result.complete();
        }
        return result;
    }
}

