/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.vertx.core.Future;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.util.ConfigurationSupportingVerticle;
import org.eclipse.hono.util.EventBusMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventBusService<C>
extends ConfigurationSupportingVerticle<C> {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private MessageConsumer<JsonObject> requestConsumer;

    public final void start(Future<Void> startFuture) {
        this.registerConsumer();
        this.doStart(startFuture);
    }

    protected void doStart(Future<Void> startFuture) {
        startFuture.complete();
    }

    protected abstract String getEventBusAddress();

    public final void stop(Future<Void> stopFuture) {
        if (this.requestConsumer != null) {
            this.requestConsumer.unregister();
            this.log.info("unregistered Tenant API request consumer from event bus");
        }
        this.doStop(stopFuture);
    }

    protected void doStop(Future<Void> stopFuture) {
        stopFuture.complete();
    }

    private void registerConsumer() {
        this.requestConsumer = this.vertx.eventBus().consumer(this.getEventBusAddress());
        this.requestConsumer.handler(this::processRequestMessage);
        this.log.info("listening on event bus [address: {}] for requests", (Object)this.getEventBusAddress());
    }

    private void processRequestMessage(Message<JsonObject> msg) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("received request message: {}", (Object)((JsonObject)msg.body()).encodePrettily());
        }
        EventBusMessage request = EventBusMessage.fromJson((JsonObject)((JsonObject)msg.body()));
        this.processRequest(request).recover(t -> {
            this.log.debug("cannot process request [operation: {}]: {}", (Object)request.getOperation(), (Object)t.getMessage());
            int status = Optional.of(t).map(cause -> {
                if (cause instanceof ServiceInvocationException) {
                    return ((ServiceInvocationException)cause).getErrorCode();
                }
                return null;
            }).orElse(500);
            return Future.succeededFuture((Object)request.getResponse(status));
        }).map(response -> {
            if (response.getReplyToAddress() == null) {
                this.log.debug("sending response as direct reply to request [operation: {}]", (Object)request.getOperation());
                msg.reply((Object)response.toJson());
            } else if (response.hasResponseProperties()) {
                this.log.debug("sending response [operation: {}, reply-to: {}]", (Object)request.getOperation(), (Object)request.getReplyToAddress());
                this.vertx.eventBus().send(request.getReplyToAddress(), (Object)response.toJson());
            } else {
                this.log.warn("discarding response lacking correlation ID or operation");
            }
            return null;
        });
    }

    protected abstract Future<EventBusMessage> processRequest(EventBusMessage var1);

    protected final <T> T getTypesafeValueForField(JsonObject payload, String field) {
        Objects.requireNonNull(payload);
        Objects.requireNonNull(field);
        try {
            return (T)payload.getValue(field);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    protected final <T> T removeTypesafeValueForField(JsonObject payload, String field) {
        Objects.requireNonNull(payload);
        Objects.requireNonNull(field);
        try {
            return (T)payload.remove(field);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    protected final JsonObject getRequestPayload(JsonObject payload) {
        JsonObject result = Optional.ofNullable(payload).orElse(new JsonObject());
        Boolean enabled = (Boolean)this.getTypesafeValueForField(result, "enabled");
        if (enabled == null) {
            this.log.debug("adding 'enabled=true' property to request payload");
            result.put("enabled", Boolean.TRUE);
        }
        return result;
    }
}

