/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.client.MessageConsumer;
import org.eclipse.hono.client.MessageSender;
import org.eclipse.hono.client.RegistrationClient;
import org.eclipse.hono.client.TenantClient;
import org.eclipse.hono.config.ProtocolAdapterProperties;
import org.eclipse.hono.service.AbstractServiceBase;
import org.eclipse.hono.service.auth.TenantApiTrustOptions;
import org.eclipse.hono.service.auth.device.Device;
import org.eclipse.hono.service.command.CommandConnection;
import org.eclipse.hono.service.command.CommandResponseSender;
import org.eclipse.hono.service.monitoring.ConnectionEventProducer;
import org.eclipse.hono.util.Constants;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;
import org.eclipse.hono.util.TenantObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractProtocolAdapterBase<T extends ProtocolAdapterProperties>
extends AbstractServiceBase<T> {
    protected static final String CONTENT_TYPE_OCTET_STREAM = "application/octet-stream";
    private HonoClient messagingClient;
    private HonoClient registrationClient;
    private HonoClient tenantClient;
    private HonoClient credentialsServiceClient;
    private CommandConnection commandConnection;
    private ConnectionEventProducer connectionEventProducer;

    @Autowired
    public void setConfig(T configuration) {
        this.setSpecificConfig(configuration);
    }

    @Qualifier(value="tenant")
    @Autowired
    public final void setTenantServiceClient(HonoClient tenantClient) {
        this.tenantClient = Objects.requireNonNull(tenantClient);
    }

    public final HonoClient getTenantServiceClient() {
        return this.tenantClient;
    }

    protected final Future<TenantClient> getTenantClient() {
        return this.getTenantServiceClient().getOrCreateTenantClient();
    }

    @Qualifier(value="messaging")
    @Autowired
    public final void setHonoMessagingClient(HonoClient honoClient) {
        this.messagingClient = Objects.requireNonNull(honoClient);
    }

    public final HonoClient getHonoMessagingClient() {
        return this.messagingClient;
    }

    @Qualifier(value="registration")
    @Autowired
    public final void setRegistrationServiceClient(HonoClient registrationServiceClient) {
        this.registrationClient = Objects.requireNonNull(registrationServiceClient);
    }

    public final HonoClient getRegistrationServiceClient() {
        return this.registrationClient;
    }

    @Qualifier(value="credentials")
    @Autowired
    public final void setCredentialsServiceClient(HonoClient credentialsServiceClient) {
        this.credentialsServiceClient = Objects.requireNonNull(credentialsServiceClient);
    }

    public final HonoClient getCredentialsServiceClient() {
        return this.credentialsServiceClient;
    }

    @Autowired(required=false)
    public void setConnectionEventProducer(ConnectionEventProducer connectionEventProducer) {
        this.connectionEventProducer = connectionEventProducer;
    }

    public ConnectionEventProducer getConnectionEventProducer() {
        return this.connectionEventProducer;
    }

    protected abstract String getTypeName();

    @Autowired
    public final void setCommandConnection(CommandConnection commandConnection) {
        this.commandConnection = commandConnection;
    }

    @Override
    protected final Future<Void> startInternal() {
        Future result = Future.future();
        if (Strings.isNullOrEmpty((Object)this.getTypeName())) {
            result.fail((Throwable)new IllegalStateException("adapter does not define a typeName"));
        } else if (this.tenantClient == null) {
            result.fail((Throwable)new IllegalStateException("Tenant service client must be set"));
        } else if (this.messagingClient == null) {
            result.fail((Throwable)new IllegalStateException("Hono Messaging client must be set"));
        } else if (this.registrationClient == null) {
            result.fail((Throwable)new IllegalStateException("Device Registration service client must be set"));
        } else if (this.credentialsServiceClient == null) {
            result.fail((Throwable)new IllegalStateException("Credentials service client must be set"));
        } else if (this.commandConnection == null) {
            result.fail((Throwable)new IllegalStateException("Command and Control service client must be set"));
        } else {
            this.connectToService(this.tenantClient, "Tenant service");
            this.connectToService(this.messagingClient, "Messaging");
            this.connectToService(this.registrationClient, "Device Registration service");
            this.connectToService(this.credentialsServiceClient, "Credentials service");
            this.connectToService(this.commandConnection, "Command and Control service");
            this.doStart((Future<Void>)result);
        }
        return result;
    }

    protected void doStart(Future<Void> startFuture) {
        startFuture.complete();
    }

    @Override
    protected final Future<Void> stopInternal() {
        this.LOG.info("stopping protocol adapter");
        Future result = Future.future();
        Future doStopResult = Future.future();
        this.doStop((Future<Void>)doStopResult);
        doStopResult.compose(s -> this.closeServiceClients()).recover(t -> {
            this.LOG.info("error while stopping protocol adapter", t);
            return Future.failedFuture((Throwable)t);
        }).compose(s -> {
            result.complete();
            this.LOG.info("successfully stopped protocol adapter");
        }, result);
        return result;
    }

    private CompositeFuture closeServiceClients() {
        return CompositeFuture.all(this.closeServiceClient(this.tenantClient), this.closeServiceClient(this.messagingClient), this.closeServiceClient(this.registrationClient), this.closeServiceClient(this.credentialsServiceClient));
    }

    private Future<Void> closeServiceClient(HonoClient client) {
        Future shutdownTracker = Future.future();
        if (client == null) {
            shutdownTracker.complete();
        } else {
            client.shutdown(shutdownTracker.completer());
        }
        return shutdownTracker;
    }

    protected void doStop(Future<Void> stopFuture) {
        stopFuture.complete();
    }

    @Override
    protected TrustOptions getServerTrustOptions() {
        return Optional.ofNullable(((ProtocolAdapterProperties)this.getConfig()).getTrustOptions()).orElse(new TenantApiTrustOptions(this.getTenantServiceClient()));
    }

    protected final Future<HonoClient> connectToService(HonoClient client, String serviceName) {
        Objects.requireNonNull(serviceName);
        if (client == null) {
            return Future.failedFuture((Throwable)new IllegalStateException(String.format("Hono %s client not set", serviceName)));
        }
        Handler<ProtonConnection> disconnectHandler = this.getHandlerForDisconnectHonoService(client, serviceName);
        return client.connect(disconnectHandler).map(connectedClient -> {
            this.LOG.info("connected to {}", (Object)serviceName);
            return connectedClient;
        }).recover(t -> {
            this.LOG.warn("failed to connect to {}", (Object)serviceName, t);
            return Future.failedFuture((Throwable)t);
        });
    }

    private Handler<ProtonConnection> getHandlerForDisconnectHonoService(HonoClient client, String serviceName) {
        return connection -> this.vertx.setTimer(500L, reconnect -> {
            this.LOG.info("attempting to reconnect to {}", (Object)serviceName);
            client.connect(this.getHandlerForDisconnectHonoService(client, serviceName)).setHandler(connectAttempt -> {
                if (connectAttempt.succeeded()) {
                    this.LOG.info("reconnected to {}", (Object)serviceName);
                } else {
                    this.LOG.debug("cannot reconnect to {}: {}", (Object)serviceName, (Object)connectAttempt.cause().getMessage());
                }
            });
        });
    }

    protected final Future<Void> isConnected() {
        Future tenantCheck = Optional.ofNullable(this.tenantClient).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new IllegalStateException("Tenant service client is not set")));
        Future messagingCheck = Optional.ofNullable(this.messagingClient).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new IllegalStateException("Messaging client is not set")));
        Future registrationCheck = Optional.ofNullable(this.registrationClient).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new IllegalStateException("Device Registration service client is not set")));
        Future credentialsCheck = Optional.ofNullable(this.credentialsServiceClient).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new IllegalStateException("Credentials service client is not set")));
        return CompositeFuture.all((Future)tenantCheck, (Future)messagingCheck, (Future)registrationCheck, (Future)credentialsCheck).compose(ok -> Future.succeededFuture());
    }

    public final Future<MessageConsumer> createCommandConsumer(String tenantId, String deviceId, BiConsumer<ProtonDelivery, Message> messageConsumer, Handler<Void> closeHandler) {
        return this.commandConnection.createCommandConsumer(tenantId, deviceId, messageConsumer, closeHandler);
    }

    public final Future<CommandResponseSender> createCommandResponseSender(String tenantId, String deviceId, String replyId) {
        return this.commandConnection.getOrCreateCommandResponseSender(tenantId, deviceId, replyId);
    }

    protected final Optional<String> validateAndGenerateCommandRequestId(String tenantId, String deviceId, Message commandMessage) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(commandMessage);
        Optional<String> replyToId = this.getReplyToIdFromCommand(tenantId, deviceId, commandMessage);
        if (replyToId.isPresent()) {
            return Optional.of(Constants.combineTwoStrings((String)this.getCorrelationIdFromMessage(commandMessage), (String)replyToId.get()));
        }
        return Optional.empty();
    }

    protected final Optional<String> getReplyToIdFromCommand(String tenantId, String deviceId, Message commandMessage) {
        String commandReplyId = commandMessage.getReplyTo();
        if (commandReplyId == null) {
            return Optional.empty();
        }
        String commandReplyResourceForValidation = ResourceIdentifier.from((String)"control", (String)tenantId, (String)deviceId).toString();
        if (!commandReplyId.startsWith(commandReplyResourceForValidation)) {
            return Optional.empty();
        }
        if (commandReplyId.length() == commandReplyResourceForValidation.length()) {
            return Optional.empty();
        }
        return Optional.of(commandReplyId.substring(commandReplyResourceForValidation.length() + 1));
    }

    protected final String getCorrelationIdFromMessage(Message message) {
        return Optional.ofNullable(message.getCorrelationId()).orElse(message.getMessageId()).toString();
    }

    protected final Future<MessageSender> getTelemetrySender(String tenantId) {
        return this.getHonoMessagingClient().getOrCreateTelemetrySender(tenantId);
    }

    protected final Future<MessageSender> getEventSender(String tenantId) {
        return this.getHonoMessagingClient().getOrCreateEventSender(tenantId);
    }

    protected final Future<RegistrationClient> getRegistrationClient(String tenantId) {
        return this.getRegistrationServiceClient().getOrCreateRegistrationClient(tenantId);
    }

    protected final Future<JsonObject> getRegistrationAssertion(String tenantId, String deviceId, Device authenticatedDevice) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Future<String> gatewayId = this.getGatewayId(tenantId, deviceId, authenticatedDevice);
        return gatewayId.compose(gwId -> this.getRegistrationClient(tenantId)).compose(client -> client.assertRegistration(deviceId, (String)gatewayId.result()));
    }

    private Future<String> getGatewayId(String tenantId, String deviceId, Device authenticatedDevice) {
        Future result = Future.future();
        if (authenticatedDevice == null) {
            result.complete(null);
        } else if (tenantId.equals(authenticatedDevice.getTenantId())) {
            if (deviceId.equals(authenticatedDevice.getDeviceId())) {
                result.complete(null);
            } else {
                result.complete((Object)authenticatedDevice.getDeviceId());
            }
        } else {
            result.fail((Throwable)new ClientErrorException(403, "cannot publish data for device of other tenant"));
        }
        return result;
    }

    protected final Future<TenantObject> getTenantConfiguration(String tenantId) {
        Objects.requireNonNull(tenantId);
        return this.getTenantClient().compose(client -> client.get(tenantId));
    }

    protected final void addProperties(Message message, JsonObject registrationInfo) {
        this.addProperties(message, registrationInfo, true);
    }

    protected final void addProperties(Message message, JsonObject registrationInfo, boolean regAssertionRequired) {
        JsonObject defaults;
        if (regAssertionRequired) {
            String registrationAssertion = registrationInfo.getString("assertion");
            MessageHelper.addRegistrationAssertion((Message)message, (String)registrationAssertion);
        }
        MessageHelper.addProperty((Message)message, (String)"orig_adapter", (Object)this.getTypeName());
        if (((ProtocolAdapterProperties)this.getConfig()).isDefaultsEnabled() && (defaults = registrationInfo.getJsonObject("defaults")) != null) {
            this.addDefaults(message, defaults);
        }
        if (Strings.isNullOrEmpty((Object)message.getContentType())) {
            message.setContentType(CONTENT_TYPE_OCTET_STREAM);
        }
        if (((ProtocolAdapterProperties)this.getConfig()).isJmsVendorPropsEnabled()) {
            MessageHelper.addJmsVendorProperties((Message)message);
        }
    }

    private void addDefaults(Message message, JsonObject defaults) {
        defaults.forEach(prop -> {
            switch ((String)prop.getKey()) {
                case "content-type": {
                    if (!Strings.isNullOrEmpty((Object)message.getContentType()) || !String.class.isInstance(prop.getValue())) break;
                    message.setContentType((String)prop.getValue());
                    break;
                }
                case "content-encoding": {
                    if (!Strings.isNullOrEmpty((Object)message.getContentEncoding()) || !String.class.isInstance(prop.getValue())) break;
                    message.setContentEncoding((String)prop.getValue());
                    break;
                }
                case "absolute-expiry-time": 
                case "correlation-id": 
                case "creation-time": 
                case "group-id": 
                case "group-sequence": 
                case "message-id": 
                case "reply-to": 
                case "reply-to-group-id": 
                case "subject": 
                case "to": 
                case "user-id": {
                    this.LOG.debug("ignoring default property [{}] registered for device", prop.getKey());
                    break;
                }
                default: {
                    MessageHelper.addProperty((Message)message, (String)((String)prop.getKey()), prop.getValue());
                }
            }
        });
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler handler) {
        handler.register("connection-to-services", status -> this.isConnected().map(connected -> {
            status.tryComplete((Object)Status.OK());
            return null;
        }).otherwise(t -> {
            status.tryComplete((Object)Status.KO());
            return null;
        }));
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler handler) {
    }

    protected final Message newMessage(ResourceIdentifier target, boolean regAssertionRequired, String publishAddress, String contentType, Buffer payload, JsonObject registrationInfo, Integer timeUntilDisconnect) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(registrationInfo);
        Message msg = ProtonHelper.message();
        msg.setAddress(target.getBasePath());
        MessageHelper.addDeviceId((Message)msg, (String)target.getResourceId());
        if (!regAssertionRequired) {
            MessageHelper.annotate((Message)msg, (ResourceIdentifier)target);
        }
        if (publishAddress != null) {
            MessageHelper.addProperty((Message)msg, (String)"orig_address", (Object)publishAddress);
        }
        if (contentType != null) {
            msg.setContentType(contentType);
        }
        if (payload != null) {
            msg.setBody((Section)new Data(new Binary(payload.getBytes())));
        }
        if (timeUntilDisconnect != null) {
            MessageHelper.addTimeUntilDisconnect((Message)msg, (int)timeUntilDisconnect);
        }
        MessageHelper.setCreationTime((Message)msg);
        this.addProperties(msg, registrationInfo, regAssertionRequired);
        return msg;
    }

    protected Future<?> sendConnectedEvent(String remoteId, Device authenticatedDevice) {
        if (this.connectionEventProducer != null) {
            return this.connectionEventProducer.connected(remoteId, this.getTypeName(), authenticatedDevice, null);
        }
        return Future.succeededFuture();
    }

    protected Future<?> sendDisconnectedEvent(String remoteId, Device authenticatedDevice) {
        if (this.connectionEventProducer != null) {
            return this.connectionEventProducer.disconnected(remoteId, this.getTypeName(), authenticatedDevice, null);
        }
        return Future.succeededFuture();
    }

    protected boolean isPayloadOfIndicatedType(Buffer payload, String contentType) {
        if (payload == null || payload.length() == 0) {
            return "application/vnd.eclipse-hono-empty-notification".equals(contentType);
        }
        return !"application/vnd.eclipse-hono-empty-notification".equals(contentType);
    }
}

