/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;
import org.eclipse.hono.config.ApplicationConfigProperties;
import org.eclipse.hono.service.AbstractServiceBase;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.HealthCheckServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class AbstractApplication
implements ApplicationRunner {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<ObjectFactory<? extends AbstractServiceBase<?>>> serviceFactories = new HashSet();
    private ApplicationConfigProperties config = new ApplicationConfigProperties();
    private Vertx vertx;
    private HealthCheckServer healthCheckServer;

    @Autowired
    public final void setVertx(Vertx vertx) {
        this.vertx = Objects.requireNonNull(vertx);
    }

    protected Vertx getVertx() {
        return this.vertx;
    }

    @Autowired
    public final void addServiceFactories(Set<ObjectFactory<? extends AbstractServiceBase<?>>> factories) {
        Objects.requireNonNull(factories);
        this.serviceFactories.addAll(factories);
        this.log.debug("added {} service factories", (Object)factories.size());
    }

    @Autowired(required=false)
    public final void setApplicationConfiguration(ApplicationConfigProperties config) {
        this.config = Objects.requireNonNull(config);
    }

    public void run(ApplicationArguments args) {
        if (this.vertx == null) {
            throw new IllegalStateException("no Vert.x instance has been configured");
        }
        if (this.serviceFactories.isEmpty()) {
            throw new IllegalStateException("no service factory has been configured");
        }
        this.healthCheckServer = new HealthCheckServer(this.vertx, this.config);
        Future future = this.deployRequiredVerticles(this.config.getMaxInstances()).compose(s -> this.deployServiceVerticles()).compose(s -> this.postRegisterServiceVerticles()).compose(s -> this.healthCheckServer.start());
        CompletableFuture started = new CompletableFuture();
        future.setHandler(result -> {
            if (result.failed()) {
                started.completeExceptionally(result.cause());
            } else {
                started.complete(null);
            }
        });
        int startupTimeoutSeconds = this.config.getStartupTimeout();
        try {
            this.log.debug("Waiting for {} seconds to start up", (Object)startupTimeoutSeconds);
            started.get(startupTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.log.error("startup timed out after {} seconds, shutting down ...", (Object)startupTimeoutSeconds);
            this.shutdown();
        }
        catch (InterruptedException e) {
            this.log.error("startup process has been interrupted, shutting down ...");
            Thread.currentThread().interrupt();
            this.shutdown();
        }
        catch (ExecutionException e) {
            this.log.error("exception occurred during startup, shutting down ...", (Throwable)e);
            this.shutdown();
        }
    }

    private CompositeFuture deployServiceVerticles() {
        int maxInstances = this.config.getMaxInstances();
        ArrayList<Future> deploymentTracker = new ArrayList<Future>();
        for (ObjectFactory<? extends AbstractServiceBase<?>> objectFactory : this.serviceFactories) {
            AbstractServiceBase serviceInstance = (AbstractServiceBase)objectFactory.getObject();
            this.healthCheckServer.registerHealthCheckResources(serviceInstance);
            Future deployTracker = Future.future();
            this.vertx.deployVerticle((Verticle)serviceInstance, deployTracker.completer());
            deploymentTracker.add(deployTracker);
            for (int i = 1; i < maxInstances; ++i) {
                serviceInstance = (AbstractServiceBase)objectFactory.getObject();
                this.log.debug("created new instance of service: {}", (Object)serviceInstance);
                Future tracker = Future.future();
                this.vertx.deployVerticle((Verticle)serviceInstance, tracker.completer());
                deploymentTracker.add(tracker);
            }
        }
        return CompositeFuture.all(deploymentTracker);
    }

    protected Future<Void> deployRequiredVerticles(int maxInstances) {
        return Future.succeededFuture();
    }

    @PreDestroy
    public final void shutdown() {
        int shutdownTimeoutSeconds = this.config.getStartupTimeout();
        this.shutdown(shutdownTimeoutSeconds, (Handler<Boolean>)((Handler)succeeded -> {}));
    }

    public final void shutdown(long maxWaitTime, Handler<Boolean> shutdownHandler) {
        try {
            this.log.info("shutting down application...");
            this.preShutdown();
            CountDownLatch latch = new CountDownLatch(1);
            this.stopHealthCheckServer().setHandler(result -> {
                if (this.vertx != null) {
                    this.log.info("closing vert.x instance ...");
                    this.vertx.close(r -> {
                        if (r.failed()) {
                            this.log.error("could not close vert.x instance", r.cause());
                        }
                        latch.countDown();
                    });
                } else {
                    latch.countDown();
                }
            });
            if (latch.await(maxWaitTime, TimeUnit.SECONDS)) {
                this.log.info("application has been shut down successfully");
                shutdownHandler.handle((Object)Boolean.TRUE);
            } else {
                this.log.error("shut down timed out, aborting...");
                shutdownHandler.handle((Object)Boolean.FALSE);
            }
        }
        catch (InterruptedException e) {
            this.log.error("application shut down has been interrupted, aborting...");
            Thread.currentThread().interrupt();
            shutdownHandler.handle((Object)Boolean.FALSE);
        }
    }

    private Future<Void> stopHealthCheckServer() {
        if (this.healthCheckServer != null) {
            return this.healthCheckServer.stop();
        }
        return Future.succeededFuture();
    }

    protected Future<Void> postRegisterServiceVerticles() {
        return Future.succeededFuture();
    }

    protected void preShutdown() {
    }

    protected final void registerHealthchecks(HealthCheckProvider provider) {
        this.healthCheckServer.registerHealthCheckResources(provider);
    }
}

