/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store.device;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.hono.service.base.jdbc.store.SQL;
import org.eclipse.hono.service.base.jdbc.store.StatementConfiguration;

public final class Configurations {
    public static final String DEFAULT_TABLE_NAME_CREDENTIALS = "device_credentials";
    public static final String DEFAULT_TABLE_NAME_REGISTRATIONS = "device_registrations";
    public static final String DEFAULT_TABLE_NAME_GROUPS = "device_groups";

    private Configurations() {
    }

    public static StatementConfiguration tableConfiguration(String jdbcUrl, Optional<String> tableNameCredentials, Optional<String> tableNameRegistrations, Optional<String> tableNameGroups) throws IOException {
        String dialect = SQL.getDatabaseDialect(jdbcUrl);
        String tableNameCredentialsString = tableNameCredentials.orElse(DEFAULT_TABLE_NAME_CREDENTIALS);
        String tableNameRegistrationsString = tableNameRegistrations.orElse(DEFAULT_TABLE_NAME_REGISTRATIONS);
        String tableNameGroupsString = tableNameGroups.orElse(DEFAULT_TABLE_NAME_GROUPS);
        Path base = StatementConfiguration.DEFAULT_PATH.resolve("device");
        return StatementConfiguration.empty(tableNameRegistrationsString, tableNameCredentialsString, tableNameGroupsString).overrideWithDefaultPattern("base", dialect, Configurations.class, base);
    }
}

