/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store.tenant;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.SQLOperations;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.service.base.jdbc.store.SQL;
import org.eclipse.hono.service.base.jdbc.store.Statement;
import org.eclipse.hono.service.base.jdbc.store.StatementConfiguration;
import org.eclipse.hono.service.base.jdbc.store.tenant.AbstractTenantStore;
import org.eclipse.hono.service.base.jdbc.store.tenant.TenantReadResult;
import org.eclipse.hono.service.management.tenant.Tenant;
import org.eclipse.hono.tracing.TracingHelper;

public class AdapterStore
extends AbstractTenantStore {
    private final Statement readByTrustAnchorStatement;

    public AdapterStore(JDBCClient client, Tracer tracer, StatementConfiguration cfg) {
        super(client, tracer, cfg);
        this.readByTrustAnchorStatement = cfg.getRequiredStatement("readByTrustAnchor").validateParameters("subject_dn");
    }

    public static StatementConfiguration defaultStatementConfiguration(String jdbcUrl, Optional<String> tenantTableName, Optional<String> trustAnchorsTenantName) throws IOException {
        String dialect = SQL.getDatabaseDialect(jdbcUrl);
        String tenantTableNameString = tenantTableName.orElse("tenants");
        String trustAnchorsTableNameString = trustAnchorsTenantName.orElse("tenant_trust_anchors");
        return StatementConfiguration.empty(tenantTableNameString, trustAnchorsTableNameString).overrideWithDefaultPattern("base", dialect, AdapterStore.class, StatementConfiguration.DEFAULT_PATH.resolve("tenant"));
    }

    public Future<Optional<JsonObject>> getById(String id, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"get tenant by id", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)id).start();
        return this.readTenant(id, span.context()).map(result -> result.map(AdapterStore::convert)).onComplete(x -> span.finish());
    }

    private Future<Optional<TenantReadResult>> readTenantByTrustAnchor(String subjectDn, SpanContext spanContext) {
        Statement.ExpandedStatement expanded = this.readByTrustAnchorStatement.expand(map -> map.put("subject_dn", subjectDn));
        return this.readTenantBy((SQLOperations)this.client, expanded, spanContext);
    }

    public Future<Optional<JsonObject>> getByTrustAnchor(String subjectDn, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"get tenant by trust anchor", (String)this.getClass().getSimpleName()).withTag("subject_dn", subjectDn).start();
        return this.readTenantByTrustAnchor(subjectDn, span.context()).map(result -> result.map(AdapterStore::convert)).onComplete(x -> span.finish());
    }

    static JsonObject convert(TenantReadResult tenantReadResult) {
        return DeviceRegistryUtils.convertTenant((String)tenantReadResult.getId(), (Tenant)tenantReadResult.getTenant());
    }
}

