/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.authentication.spring;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.proton.sasl.ProtonSaslAuthenticatorFactory;
import org.eclipse.hono.authentication.AuthenticationEndpoint;
import org.eclipse.hono.authentication.SimpleAuthenticationServer;
import org.eclipse.hono.authentication.file.FileBasedAuthenticationService;
import org.eclipse.hono.authentication.spring.FileBasedAuthenticationServiceConfigProperties;
import org.eclipse.hono.config.ApplicationConfigProperties;
import org.eclipse.hono.config.ServerConfig;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.config.SignatureSupportingConfigProperties;
import org.eclipse.hono.config.VertxProperties;
import org.eclipse.hono.service.HealthCheckServer;
import org.eclipse.hono.service.VertxBasedHealthCheckServer;
import org.eclipse.hono.service.amqp.AmqpEndpoint;
import org.eclipse.hono.service.auth.AuthTokenHelper;
import org.eclipse.hono.service.auth.AuthTokenHelperImpl;
import org.eclipse.hono.service.auth.AuthenticationService;
import org.eclipse.hono.service.auth.HonoSaslAuthenticatorFactory;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.service.metric.spring.PrometheusSupport;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ObjectFactoryCreatingFactoryBean;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;

@Configuration
@Import(value={PrometheusSupport.class})
public class ApplicationConfig {
    private static final String BEAN_NAME_SIMPLE_AUTHENTICATION_SERVER = "simpleAuthenticationServer";

    @Bean
    public Vertx vertx() {
        return Vertx.vertx((VertxOptions)this.vertxProperties().configureVertx(new VertxOptions()));
    }

    @ConfigurationProperties(value="hono.vertx")
    @Bean
    public VertxProperties vertxProperties() {
        return new VertxProperties();
    }

    @Bean(name={"simpleAuthenticationServer"})
    @Scope(value="prototype")
    public SimpleAuthenticationServer simpleAuthenticationServer() {
        SimpleAuthenticationServer server = new SimpleAuthenticationServer();
        server.setConfig(this.amqpProperties());
        server.setSaslAuthenticatorFactory(this.authenticatorFactory());
        return server;
    }

    @Bean
    public ObjectFactoryCreatingFactoryBean authServerFactory() {
        ObjectFactoryCreatingFactoryBean factory = new ObjectFactoryCreatingFactoryBean();
        factory.setTargetBeanName(BEAN_NAME_SIMPLE_AUTHENTICATION_SERVER);
        return factory;
    }

    @Bean
    @ConfigurationProperties(prefix="hono.app")
    public ApplicationConfigProperties applicationConfigProperties() {
        return new ApplicationConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.auth.amqp")
    public ServiceConfigProperties amqpProperties() {
        return new ServiceConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.auth.svc")
    public FileBasedAuthenticationServiceConfigProperties serviceProperties() {
        return new FileBasedAuthenticationServiceConfigProperties();
    }

    @Bean
    @Qualifier(value="signing")
    public AuthTokenHelper authTokenFactory() {
        ServiceConfigProperties amqpProps = this.amqpProperties();
        FileBasedAuthenticationServiceConfigProperties serviceProps = this.serviceProperties();
        if (!serviceProps.getSigning().isAppropriateForCreating() && amqpProps.getKeyPath() != null) {
            serviceProps.getSigning().setKeyPath(amqpProps.getKeyPath());
        }
        return AuthTokenHelperImpl.forSigning((Vertx)this.vertx(), (SignatureSupportingConfigProperties)serviceProps.getSigning());
    }

    @Bean
    FileBasedAuthenticationService authenticationService() {
        FileBasedAuthenticationService service = new FileBasedAuthenticationService();
        service.setConfig((org.eclipse.hono.authentication.file.FileBasedAuthenticationServiceConfigProperties)this.serviceProperties());
        service.setTokenFactory(this.authTokenFactory());
        return service;
    }

    @Bean
    @Scope(value="prototype")
    public AmqpEndpoint authenticationEndpoint() {
        return new AuthenticationEndpoint(this.vertx());
    }

    @Bean
    @Qualifier(value="authentication")
    public AuthTokenHelper tokenValidator() {
        ServiceConfigProperties amqpProps = this.amqpProperties();
        FileBasedAuthenticationServiceConfigProperties serviceProps = this.serviceProperties();
        if (!serviceProps.getValidation().isAppropriateForValidating() && amqpProps.getCertPath() != null) {
            serviceProps.getValidation().setCertPath(amqpProps.getCertPath());
        }
        return AuthTokenHelperImpl.forValidating((Vertx)this.vertx(), (SignatureSupportingConfigProperties)serviceProps.getValidation());
    }

    @Bean
    public ProtonSaslAuthenticatorFactory authenticatorFactory() {
        return new HonoSaslAuthenticatorFactory(this.vertx(), this.tokenValidator(), (AuthenticationService)this.authenticationService());
    }

    @Bean
    public MeterRegistryCustomizer<MeterRegistry> commonTags() {
        return r -> r.config().commonTags((Iterable)MetricsTags.forService((String)"hono-auth"));
    }

    @Bean
    @ConfigurationProperties(prefix="hono.health-check")
    public ServerConfig healthCheckConfigProperties() {
        return new ServerConfig();
    }

    @Bean
    public HealthCheckServer healthCheckServer() {
        return new VertxBasedHealthCheckServer(this.vertx(), this.healthCheckConfigProperties());
    }
}

