/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import java.util.Objects;
import org.eclipse.hono.service.AbstractApplication;
import org.eclipse.hono.service.auth.impl.FileBasedAuthenticationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@ComponentScan(basePackages={"org.eclipse.hono.service.auth", "org.eclipse.hono.service.metric"})
@Configuration
@EnableAutoConfiguration
public class Application
extends AbstractApplication {
    private FileBasedAuthenticationService authenticationService;

    @Autowired
    public void setAuthenticationService(FileBasedAuthenticationService authService) {
        this.authenticationService = Objects.requireNonNull(authService);
    }

    protected Future<Void> deployRequiredVerticles(int maxInstances) {
        Promise result = Promise.promise();
        if (this.authenticationService == null) {
            result.fail("no authentication service implementation configured");
        } else {
            this.log.debug("deploying {}", (Object)this.authenticationService);
            this.getVertx().deployVerticle((Verticle)this.authenticationService, s -> {
                if (s.succeeded()) {
                    result.complete();
                } else {
                    result.fail(s.cause());
                }
            });
        }
        return result.future();
    }

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }
}

