/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.impl;

import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonLink;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.ProtonSender;
import io.vertx.proton.ProtonSession;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.Source;
import org.eclipse.hono.auth.Authorities;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.AmqpEndpoint;
import org.eclipse.hono.service.amqp.AmqpServiceBase;
import org.eclipse.hono.util.Constants;
import org.eclipse.hono.util.ResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class SimpleAuthenticationServer
extends AmqpServiceBase<ServiceConfigProperties> {
    public static final Symbol CAPABILITY_ADDRESS_AUTHZ = Symbol.valueOf((String)"ADDRESS-AUTHZ");
    public static final Symbol PROPERTY_ADDRESS_AUTHZ = Symbol.valueOf((String)"address-authz");
    public static final Symbol PROPERTY_AUTH_IDENTITY = Symbol.valueOf((String)"authenticated-identity");
    public static final Symbol PROPERTY_CLIENT_VERSION = Symbol.valueOf((String)"version");
    private static final int IDX_MAJOR_VERSION = 0;
    private static final int IDX_MINOR_VERSION = 1;
    private static final int IDX_PATCH_VERSION = 2;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleAuthenticationServer.class);

    @Autowired
    public void setConfig(ServiceConfigProperties configuration) {
        this.setSpecificConfig(configuration);
    }

    protected String getServiceName() {
        return "hono-auth";
    }

    protected void setRemoteConnectionOpenHandler(ProtonConnection connection) {
        connection.sessionOpenHandler(remoteOpenSession -> this.handleSessionOpen(connection, (ProtonSession)remoteOpenSession));
        connection.senderOpenHandler(remoteOpenSender -> this.handleSenderOpen(connection, (ProtonSender)remoteOpenSender));
        connection.disconnectHandler(con -> {
            con.close();
            con.disconnect();
        });
        connection.closeHandler(remoteClose -> {
            connection.close();
            connection.disconnect();
        });
        connection.openHandler(remoteOpen -> {
            if (remoteOpen.failed()) {
                LOG.debug("ignoring peer's open frame containing error", remoteOpen.cause());
            } else {
                this.processRemoteOpen((ProtonConnection)remoteOpen.result());
            }
        });
    }

    protected void processRemoteOpen(ProtonConnection connection) {
        boolean isAddressAuthz = Arrays.stream(connection.getRemoteDesiredCapabilities()).anyMatch(symbol -> symbol.equals(CAPABILITY_ADDRESS_AUTHZ));
        if (isAddressAuthz) {
            LOG.debug("client [container: {}] requests transfer of authenticated user's authorities in open frame", (Object)connection.getRemoteContainer());
            this.processAddressAuthzCapability(connection);
        }
        connection.open();
        this.vertx.setTimer(5000L, closeCon -> {
            if (!connection.isDisconnected()) {
                LOG.debug("connection with client [{}] timed out after 5 seconds, closing connection", (Object)connection.getRemoteContainer());
                connection.setCondition(ProtonHelper.condition((Symbol)Constants.AMQP_ERROR_INACTIVITY, (String)"client must retrieve token within 5 secs after opening connection")).close();
            }
        });
    }

    private void processAddressAuthzCapability(ProtonConnection connection) {
        Map remoteProperties;
        if (LOG.isDebugEnabled() && (remoteProperties = connection.getRemoteProperties()) != null) {
            String props = remoteProperties.entrySet().stream().map(entry -> String.format("[%s: %s]", entry.getKey(), entry.getValue().toString())).collect(Collectors.joining(", "));
            LOG.debug("client connection [container: {}] includes properties: {}", (Object)connection.getRemoteContainer(), (Object)props);
        }
        HonoUser clientPrincipal = Constants.getClientPrincipal((ProtonConnection)connection);
        Map<String, String[]> permissions = this.getPermissionsFromAuthorities(clientPrincipal.getAuthorities());
        HashMap<Symbol, Object> properties = new HashMap<Symbol, Object>();
        boolean isLegacy = this.isLegacyClient(connection);
        if (isLegacy) {
            properties.put(PROPERTY_AUTH_IDENTITY, clientPrincipal.getName());
        } else {
            properties.put(PROPERTY_AUTH_IDENTITY, Collections.singletonMap("sub", clientPrincipal.getName()));
        }
        properties.put(PROPERTY_ADDRESS_AUTHZ, permissions);
        connection.setProperties(properties);
        connection.setOfferedCapabilities(new Symbol[]{CAPABILITY_ADDRESS_AUTHZ});
        LOG.debug("transferring {} permissions of client [container: {}, user: {}] in open frame [legacy format: {}]", new Object[]{permissions.size(), connection.getRemoteContainer(), clientPrincipal.getName(), isLegacy});
    }

    private boolean isLegacyClient(ProtonConnection con) {
        return Optional.ofNullable(con.getRemoteProperties()).map(props -> {
            Object obj = props.get(PROPERTY_CLIENT_VERSION);
            if (obj instanceof String) {
                int[] version = this.parseVersionString((String)obj);
                return version[0] == 1 && version[1] < 4;
            }
            return false;
        }).orElse(false);
    }

    private int[] parseVersionString(String version) {
        int[] result = new int[]{0, 0, 0};
        String[] versionNumbers = version.split("\\.", 3);
        try {
            if (versionNumbers.length > 0) {
                result[0] = Integer.parseInt(versionNumbers[0]);
            }
            if (versionNumbers.length > 1) {
                result[1] = Integer.parseInt(versionNumbers[1]);
            }
            if (versionNumbers.length > 2) {
                result[2] = Integer.parseInt(versionNumbers[2]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        LOG.debug("client Dispatch Router version [major: {}, minor: {}, patch: {}]", new Object[]{result[0], result[1], result[2]});
        return result;
    }

    private Map<String, String[]> getPermissionsFromAuthorities(Authorities authorities) {
        return authorities.asMap().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("r:")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring("r:".length()), entry -> this.getAuthorities((String)entry.getValue())));
    }

    private String[] getAuthorities(String activities) {
        Set result = activities.chars().mapToObj(act -> {
            switch (act) {
                case 82: {
                    return "recv";
                }
                case 87: {
                    return "send";
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        return (String[])result.toArray(String[]::new);
    }

    protected void handleReceiverOpen(ProtonConnection con, ProtonReceiver receiver) {
        receiver.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_ALLOWED, (String)"cannot write to node"));
        receiver.close();
    }

    protected void handleSenderOpen(ProtonConnection con, ProtonSender sender) {
        Source remoteSource = sender.getRemoteSource();
        LOG.debug("client [{}] wants to open a link for receiving messages [address: {}]", (Object)con.getRemoteContainer(), (Object)remoteSource);
        try {
            ResourceIdentifier targetResource = this.getResourceIdentifier(remoteSource.getAddress());
            AmqpEndpoint endpoint = this.getEndpoint(targetResource);
            if (endpoint == null) {
                LOG.debug("no endpoint registered for node [{}]", (Object)targetResource);
                con.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_FOUND, (String)"no such node")).close();
            } else {
                HonoUser user = Constants.getClientPrincipal((ProtonConnection)con);
                if ("ANONYMOUS".equals(user.getName())) {
                    con.setCondition(ProtonHelper.condition((Symbol)AmqpError.UNAUTHORIZED_ACCESS, (String)"client must authenticate using SASL")).close();
                } else {
                    Constants.copyProperties((ProtonConnection)con, (ProtonLink)sender);
                    sender.setSource(sender.getRemoteSource());
                    endpoint.onLinkAttach(con, sender, targetResource);
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOG.debug("client has provided invalid resource identifier as source address", (Throwable)e);
            con.setCondition(ProtonHelper.condition((Symbol)AmqpError.INVALID_FIELD, (String)"malformed source address")).close();
        }
    }
}

