/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.auth.Activity;
import org.eclipse.hono.auth.Authorities;
import org.eclipse.hono.auth.AuthoritiesImpl;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.auth.AbstractHonoAuthenticationService;
import org.eclipse.hono.service.auth.AuthTokenHelper;
import org.eclipse.hono.service.auth.impl.AuthenticationServerConfigProperties;
import org.eclipse.hono.util.AuthenticationConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"authentication-impl"})
public final class FileBasedAuthenticationService
extends AbstractHonoAuthenticationService<AuthenticationServerConfigProperties> {
    private static final String FIELD_USERS = "users";
    private static final String FIELD_ROLES = "roles";
    private static final String FIELD_OPERATION = "operation";
    private static final String FIELD_RESOURCE = "resource";
    private static final String FIELD_ACTIVITIES = "activities";
    private static final String FIELD_AUTHORITIES = "authorities";
    private static final String FIELD_MECHANISM = "mechanism";
    private static final String UNAUTHORIZED = "unauthorized";
    private static final Map<String, Authorities> roles = new HashMap<String, Authorities>();
    private static final Map<String, JsonObject> users = new HashMap<String, JsonObject>();
    private AuthTokenHelper tokenFactory;

    @Autowired
    public void setConfig(AuthenticationServerConfigProperties configuration) {
        this.setSpecificConfig(configuration);
    }

    @Autowired
    @Qualifier(value="signing")
    public void setTokenFactory(AuthTokenHelper tokenFactory) {
        this.tokenFactory = Objects.requireNonNull(tokenFactory);
    }

    protected void doStart(Future<Void> startFuture) {
        if (this.tokenFactory == null) {
            startFuture.fail("token factory must be set");
        } else {
            try {
                this.loadPermissions();
                startFuture.complete();
            }
            catch (IOException e) {
                this.log.error("cannot load permissions from resource {}", (Object)((AuthenticationServerConfigProperties)this.getConfig()).getPermissionsPath(), (Object)e);
                startFuture.fail((Throwable)e);
            }
        }
    }

    void loadPermissions() throws IOException {
        if (((AuthenticationServerConfigProperties)this.getConfig()).getPermissionsPath() == null) {
            throw new IllegalStateException("permissions resource is not set");
        }
        if (!((AuthenticationServerConfigProperties)this.getConfig()).getPermissionsPath().isReadable()) {
            throw new FileNotFoundException("permissions resource does not exist");
        }
        this.log.info("loading permissions from resource {}", (Object)((AuthenticationServerConfigProperties)this.getConfig()).getPermissionsPath().getURI().toString());
        StringBuilder json = new StringBuilder();
        this.load(((AuthenticationServerConfigProperties)this.getConfig()).getPermissionsPath(), json);
        this.parsePermissions(new JsonObject(json.toString()));
    }

    private void load(Resource source, StringBuilder target) throws IOException {
        char[] buffer = new char[4096];
        int bytesRead = 0;
        try (InputStreamReader reader = new InputStreamReader(source.getInputStream(), StandardCharsets.UTF_8);){
            while ((bytesRead = reader.read(buffer)) > 0) {
                target.append(buffer, 0, bytesRead);
            }
        }
    }

    private void parsePermissions(JsonObject permissionsObject) {
        Objects.requireNonNull(permissionsObject);
        this.parseRoles(permissionsObject.getJsonObject(FIELD_ROLES, new JsonObject()));
        this.parseUsers(permissionsObject.getJsonObject(FIELD_USERS, new JsonObject()));
    }

    private void parseRoles(JsonObject rolesObject) {
        rolesObject.stream().filter(entry -> entry.getValue() instanceof JsonArray).forEach(entry -> {
            String roleName = (String)entry.getKey();
            JsonArray authSpecs = (JsonArray)entry.getValue();
            this.log.debug("adding role [{}] with {} authorities", (Object)roleName, (Object)authSpecs.size());
            roles.put(roleName, this.toAuthorities(authSpecs));
        });
    }

    private void parseUsers(JsonObject usersObject) {
        usersObject.stream().filter(entry -> entry.getValue() instanceof JsonObject).forEach(entry -> {
            String authenticationId = (String)entry.getKey();
            JsonObject userSpec = (JsonObject)entry.getValue();
            this.log.debug("adding user [{}]", (Object)authenticationId);
            users.put(authenticationId, userSpec);
        });
    }

    private JsonObject getUser(String authenticationId, String mechanism) {
        JsonObject result = users.get(authenticationId);
        if (result != null && mechanism.equals(result.getString(FIELD_MECHANISM))) {
            return result;
        }
        return null;
    }

    private Authorities getAuthorities(JsonObject user) {
        AuthoritiesImpl result = new AuthoritiesImpl();
        user.getJsonArray(FIELD_AUTHORITIES).forEach(obj -> {
            String authority = (String)obj;
            Authorities roleAuthorities = roles.get(authority);
            if (roleAuthorities != null) {
                result.addAll(roleAuthorities);
            }
        });
        return result;
    }

    private Authorities toAuthorities(JsonArray authorities) {
        AuthoritiesImpl result = new AuthoritiesImpl();
        Objects.requireNonNull(authorities).stream().filter(obj -> obj instanceof JsonObject).forEach(obj -> {
            JsonObject authSpec = (JsonObject)obj;
            JsonArray activities = authSpec.getJsonArray(FIELD_ACTIVITIES, new JsonArray());
            String resource = authSpec.getString(FIELD_RESOURCE);
            String operation = authSpec.getString(FIELD_OPERATION);
            if (resource != null) {
                ArrayList activityList = new ArrayList();
                activities.forEach(s -> {
                    Activity act = Activity.valueOf((String)((String)s));
                    if (act != null) {
                        activityList.add(act);
                    }
                });
                result.addResource(resource, (Activity[])activityList.toArray(Activity[]::new));
            } else if (operation != null) {
                String[] parts = operation.split(":", 2);
                if (parts.length == 2) {
                    result.addOperation(parts[0], parts[1]);
                } else {
                    this.log.debug("ignoring malformed operation spec [{}], operation name missing", (Object)operation);
                }
            } else {
                throw new IllegalArgumentException("malformed authorities");
            }
        });
        return result;
    }

    private boolean hasAuthority(JsonObject user, String role) {
        return user.getJsonArray(FIELD_AUTHORITIES, new JsonArray()).contains((Object)role);
    }

    private boolean isAuthorizedToImpersonate(JsonObject user) {
        return this.hasAuthority(user, "hono-component");
    }

    public void verifyPlain(String authzid, String username, String password, Handler<AsyncResult<HonoUser>> authenticationResultHandler) {
        if (username == null || username.isEmpty()) {
            authenticationResultHandler.handle((Object)Future.failedFuture((Throwable)new ClientErrorException(400, "missing username")));
        } else if (password == null || password.isEmpty()) {
            authenticationResultHandler.handle((Object)Future.failedFuture((Throwable)new ClientErrorException(400, "missing password")));
        } else {
            JsonObject user = this.getUser(username, "PLAIN");
            if (user == null) {
                this.log.debug("no such user [{}]", (Object)username);
                authenticationResultHandler.handle((Object)Future.failedFuture((Throwable)new ClientErrorException(401, UNAUTHORIZED)));
            } else if (password.equals(user.getString("password"))) {
                this.verify(username, user, authzid, authenticationResultHandler);
            } else {
                this.log.debug("password mismatch");
                authenticationResultHandler.handle((Object)Future.failedFuture((Throwable)new ClientErrorException(401, UNAUTHORIZED)));
            }
        }
    }

    public void verifyExternal(String authzid, String subjectDn, Handler<AsyncResult<HonoUser>> authenticationResultHandler) {
        if (subjectDn == null || subjectDn.isEmpty()) {
            authenticationResultHandler.handle((Object)Future.failedFuture((Throwable)new ClientErrorException(400, "missing subject DN")));
        } else {
            String commonName = AuthenticationConstants.getCommonName((String)subjectDn);
            if (commonName == null) {
                authenticationResultHandler.handle((Object)Future.failedFuture((Throwable)new ClientErrorException(400, "could not determine authorization ID for subject DN")));
            } else {
                JsonObject user = this.getUser(commonName, "EXTERNAL");
                if (user == null) {
                    authenticationResultHandler.handle((Object)Future.failedFuture((Throwable)new ClientErrorException(401, UNAUTHORIZED)));
                } else {
                    this.verify(commonName, user, authzid, authenticationResultHandler);
                }
            }
        }
    }

    private void verify(String authenticationId, JsonObject user, String authorizationId, Handler<AsyncResult<HonoUser>> authenticationResultHandler) {
        JsonObject effectiveUser = user;
        String effectiveAuthorizationId = authenticationId;
        if (authorizationId != null && !authorizationId.isEmpty() && this.isAuthorizedToImpersonate(user)) {
            JsonObject impersonatedUser = users.get(authorizationId);
            if (impersonatedUser != null) {
                effectiveUser = impersonatedUser;
                effectiveAuthorizationId = authorizationId;
                this.log.debug("granting authorization id specified by client");
            } else {
                this.log.debug("no user found for authorization id provided by client, granting authentication id instead");
            }
        }
        final Authorities grantedAuthorities = this.getAuthorities(effectiveUser);
        final String grantedAuthorizationId = effectiveAuthorizationId;
        final Instant tokenExpirationTime = Instant.now().plus(this.tokenFactory.getTokenLifetime());
        final String token = this.tokenFactory.createToken(grantedAuthorizationId, grantedAuthorities);
        HonoUser honoUser = new HonoUser(){

            public String getName() {
                return grantedAuthorizationId;
            }

            public String getToken() {
                return token;
            }

            public Authorities getAuthorities() {
                return grantedAuthorities;
            }

            public boolean isExpired() {
                return !Instant.now().isBefore(tokenExpirationTime);
            }

            public Instant getExpirationTime() {
                return tokenExpirationTime;
            }
        };
        authenticationResultHandler.handle((Object)Future.succeededFuture((Object)honoUser));
    }
}

