/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.impl;

import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonLink;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.ProtonSender;
import io.vertx.proton.ProtonSession;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.Source;
import org.eclipse.hono.auth.Authorities;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.AmqpEndpoint;
import org.eclipse.hono.service.amqp.AmqpServiceBase;
import org.eclipse.hono.util.Constants;
import org.eclipse.hono.util.ResourceIdentifier;
import org.springframework.beans.factory.annotation.Autowired;

public final class SimpleAuthenticationServer
extends AmqpServiceBase<ServiceConfigProperties> {
    private static final Symbol CAPABILITY_ADDRESS_AUTHZ = Symbol.valueOf((String)"ADDRESS-AUTHZ");
    private static final Symbol PROPERTY_ADDRESS_AUTHZ = Symbol.valueOf((String)"address-authz");
    private static final Symbol PROPERTY_AUTH_IDENTITY = Symbol.valueOf((String)"authenticated-identity");

    @Autowired
    public void setConfig(ServiceConfigProperties configuration) {
        this.setSpecificConfig(configuration);
    }

    protected String getServiceName() {
        return "Hono-Auth";
    }

    protected void setRemoteConnectionOpenHandler(ProtonConnection connection) {
        connection.sessionOpenHandler(remoteOpenSession -> this.handleSessionOpen(connection, (ProtonSession)remoteOpenSession));
        connection.senderOpenHandler(remoteOpenSender -> this.handleSenderOpen(connection, (ProtonSender)remoteOpenSender));
        connection.disconnectHandler(con -> {
            con.close();
            con.disconnect();
        });
        connection.closeHandler(remoteClose -> {
            connection.close();
            connection.disconnect();
        });
        connection.openHandler(remoteOpen -> {
            if (remoteOpen.failed()) {
                this.LOG.debug("ignoring peer's open frame containing error", remoteOpen.cause());
            } else {
                this.processRemoteOpen((ProtonConnection)remoteOpen.result());
            }
        });
    }

    protected void processRemoteOpen(ProtonConnection connection) {
        boolean isAddressAuthz = Arrays.stream(connection.getRemoteDesiredCapabilities()).anyMatch(symbol -> symbol.equals(CAPABILITY_ADDRESS_AUTHZ));
        if (isAddressAuthz) {
            this.LOG.debug("client [container: {}] requests transfer of authenticated user's authorities in open frame", (Object)connection.getRemoteContainer());
            this.processAddressAuthzCapability(connection);
        }
        connection.open();
        this.vertx.setTimer(5000L, closeCon -> {
            if (!connection.isDisconnected()) {
                this.LOG.debug("connection with client [{}] timed out after 5 seconds, closing connection", (Object)connection.getRemoteContainer());
                connection.setCondition(ProtonHelper.condition((Symbol)Constants.AMQP_ERROR_INACTIVITY, (String)"client must retrieve token within 5 secs after opening connection")).close();
            }
        });
    }

    private void processAddressAuthzCapability(ProtonConnection connection) {
        HonoUser clientPrincipal = Constants.getClientPrincipal((ProtonConnection)connection);
        Map<String, String[]> permissions = this.getPermissionsFromAuthorities(clientPrincipal.getAuthorities());
        this.LOG.debug("transfering {} permissions of client [container: {}, user: {}] in open frame", new Object[]{permissions.size(), connection.getRemoteContainer(), clientPrincipal.getName()});
        HashMap<Symbol, Object> properties = new HashMap<Symbol, Object>();
        properties.put(PROPERTY_AUTH_IDENTITY, clientPrincipal.getName());
        properties.put(PROPERTY_ADDRESS_AUTHZ, permissions);
        connection.setProperties(properties);
        connection.setOfferedCapabilities(new Symbol[]{CAPABILITY_ADDRESS_AUTHZ});
    }

    private Map<String, String[]> getPermissionsFromAuthorities(Authorities authorities) {
        return authorities.asMap().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("r:")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring("r:".length()), entry -> this.getAuthorities((String)entry.getValue())));
    }

    private String[] getAuthorities(String activities) {
        Set<String> result = activities.chars().mapToObj(act -> {
            switch (act) {
                case 82: {
                    return "recv";
                }
                case 87: {
                    return "send";
                }
            }
            return null;
        }).filter(s -> s != null).collect(Collectors.toSet());
        return result.toArray(new String[result.size()]);
    }

    protected void handleReceiverOpen(ProtonConnection con, ProtonReceiver receiver) {
        receiver.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_ALLOWED, (String)"cannot write to node"));
        receiver.close();
    }

    protected void handleSenderOpen(ProtonConnection con, ProtonSender sender) {
        Source remoteSource = sender.getRemoteSource();
        this.LOG.debug("client [{}] wants to open a link for receiving messages [address: {}]", (Object)con.getRemoteContainer(), (Object)remoteSource);
        try {
            ResourceIdentifier targetResource = this.getResourceIdentifier(remoteSource.getAddress());
            AmqpEndpoint endpoint = this.getEndpoint(targetResource);
            if (endpoint == null) {
                this.LOG.debug("no endpoint registered for node [{}]", (Object)targetResource);
                con.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_FOUND, (String)"no such node")).close();
            } else {
                HonoUser user = Constants.getClientPrincipal((ProtonConnection)con);
                if ("ANONYMOUS".equals(user.getName())) {
                    con.setCondition(ProtonHelper.condition((Symbol)AmqpError.UNAUTHORIZED_ACCESS, (String)"client must authenticate using SASL")).close();
                } else {
                    Constants.copyProperties((ProtonConnection)con, (ProtonLink)sender);
                    sender.setSource(sender.getRemoteSource());
                    endpoint.onLinkAttach(con, sender, targetResource);
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.LOG.debug("client has provided invalid resource identifier as source address", (Throwable)e);
            con.setCondition(ProtonHelper.condition((Symbol)AmqpError.INVALID_FIELD, (String)"malformed source address")).close();
        }
    }
}

