/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.spring.autoconfigure.MeterRegistryCustomizer;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.dns.AddressResolverOptions;
import org.eclipse.hono.config.ApplicationConfigProperties;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.config.SignatureSupportingConfigProperties;
import org.eclipse.hono.service.auth.AuthTokenHelper;
import org.eclipse.hono.service.auth.AuthTokenHelperImpl;
import org.eclipse.hono.service.auth.impl.AuthenticationServerConfigProperties;
import org.eclipse.hono.service.auth.impl.SimpleAuthenticationServer;
import org.eclipse.hono.service.metric.MetricsTags;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ObjectFactoryCreatingFactoryBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class ApplicationConfig {
    private static final String BEAN_NAME_SIMPLE_AUTHENTICATION_SERVER = "simpleAuthenticationServer";

    @Bean
    public Vertx vertx() {
        VertxOptions options = new VertxOptions().setWarningExceptionTime(1500000000L).setAddressResolverOptions(new AddressResolverOptions().setCacheNegativeTimeToLive(0).setCacheMaxTimeToLive(0).setQueryTimeout(1000L));
        return Vertx.vertx((VertxOptions)options);
    }

    @Bean(name={"simpleAuthenticationServer"})
    @Scope(value="prototype")
    public SimpleAuthenticationServer simpleAuthenticationServer() {
        return new SimpleAuthenticationServer();
    }

    @Bean
    public ObjectFactoryCreatingFactoryBean authServerFactory() {
        ObjectFactoryCreatingFactoryBean factory = new ObjectFactoryCreatingFactoryBean();
        factory.setTargetBeanName(BEAN_NAME_SIMPLE_AUTHENTICATION_SERVER);
        return factory;
    }

    @Bean
    @ConfigurationProperties(prefix="hono.app")
    public ApplicationConfigProperties applicationConfigProperties() {
        return new ApplicationConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.auth.amqp")
    public ServiceConfigProperties amqpProperties() {
        ServiceConfigProperties props = new ServiceConfigProperties();
        return props;
    }

    @Bean
    @ConfigurationProperties(prefix="hono.auth.svc")
    public AuthenticationServerConfigProperties serviceProperties() {
        return new AuthenticationServerConfigProperties();
    }

    @Bean
    @Qualifier(value="signing")
    public AuthTokenHelper authTokenFactory() {
        ServiceConfigProperties amqpProps = this.amqpProperties();
        AuthenticationServerConfigProperties serviceProps = this.serviceProperties();
        if (!serviceProps.getSigning().isAppropriateForCreating() && amqpProps.getKeyPath() != null) {
            serviceProps.getSigning().setKeyPath(amqpProps.getKeyPath());
        }
        return AuthTokenHelperImpl.forSigning((Vertx)this.vertx(), (SignatureSupportingConfigProperties)serviceProps.getSigning());
    }

    @Bean
    @Qualifier(value="authentication")
    public AuthTokenHelper tokenValidator() {
        ServiceConfigProperties amqpProps = this.amqpProperties();
        AuthenticationServerConfigProperties serviceProps = this.serviceProperties();
        if (!serviceProps.getValidation().isAppropriateForValidating() && amqpProps.getCertPath() != null) {
            serviceProps.getValidation().setCertPath(amqpProps.getCertPath());
        }
        return AuthTokenHelperImpl.forValidating((Vertx)this.vertx(), (SignatureSupportingConfigProperties)serviceProps.getValidation());
    }

    @Bean
    public MeterRegistryCustomizer<MeterRegistry> commonTags() {
        return r -> r.config().commonTags((Iterable)MetricsTags.forService((String)"auth"));
    }
}

