/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.authentication;

import io.vertx.core.buffer.Buffer;
import java.util.Objects;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.hono.service.auth.AuthTokenFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/validating-keys")
public final class JwkResource {
    private static final Logger LOG = LoggerFactory.getLogger(JwkResource.class);
    private final Buffer jwkBytes;

    public JwkResource(AuthTokenFactory authTokenFactory) {
        Objects.requireNonNull(authTokenFactory);
        this.jwkBytes = authTokenFactory.getValidatingJwkSet().toBuffer();
    }

    @GET
    @Produces(value={"application/jwk-set+json"})
    public Buffer getJwk() {
        LOG.debug("serving JWK set for validating JWTs");
        return this.jwkBytes;
    }
}

