/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.authentication.file;

import java.util.List;
import java.util.Objects;
import org.eclipse.hono.config.SignatureSupportingConfigProperties;
import org.eclipse.hono.service.auth.AbstractHonoAuthenticationService;

public abstract class FileBasedAuthenticationServiceConfigProperties {
    private String permissionsPath = null;
    private List<String> supportedSaslMechanisms = List.of(AbstractHonoAuthenticationService.DEFAULT_SASL_MECHANISMS);

    public abstract SignatureSupportingConfigProperties getSigning();

    public abstract SignatureSupportingConfigProperties getValidation();

    public final String getPermissionsPath() {
        return this.permissionsPath;
    }

    public final void setPermissionsPath(String permissionsPath) {
        this.permissionsPath = Objects.requireNonNull(permissionsPath);
    }

    public final List<String> getSupportedSaslMechanisms() {
        return this.supportedSaslMechanisms;
    }

    public final void setSupportedSaslMechanisms(List<String> supportedSaslMechanisms) {
        if (Objects.requireNonNull(supportedSaslMechanisms).stream().noneMatch(AbstractHonoAuthenticationService::isCompatibleSaslMechanism)) {
            throw new IllegalArgumentException("invalid list of SASL mechanisms");
        }
        this.supportedSaslMechanisms = supportedSaslMechanisms;
    }
}

