/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.devices;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.IntPredicate;
import org.eclipse.hono.client.ServiceInvocationException;

public class HonoHttpDevice {
    public static final String DEVICE_AUTH_ID = "sensor1";
    public static final String DEVICE_PASSWORD = "hono-secret";
    public static final String HONO_HTTP_ADAPTER_HOST = "localhost";
    public static final int HONO_HTTP_ADAPTER_PORT = 8080;
    public static final String TENANT_ID = "DEFAULT_TENANT";
    protected static final String ORIGIN_URI = "http://hono.eclipse.org";
    private static final Vertx VERTX = Vertx.vertx();
    private final List<Request> requests = Arrays.asList(Request.EmptyEventWithTtd, Request.EmptyEventWithTtd, Request.EmptyEventWithTtd, Request.TelemetryWithoutTtd, Request.EmptyEventWithTtd, Request.TelemetryWithoutTtd, Request.JsonEventWithTtd, Request.TelemetryWithoutTtd, Request.JsonEventWithoutTtd, Request.EmptyEventAlreadyInvalid, Request.TelemetryWithTtd, Request.TelemetryWithoutTtd);
    private final HttpClient httpClient;
    private final MultiMap standardRequestHeaders;

    private HonoHttpDevice() {
        HttpClientOptions options = new HttpClientOptions();
        options.setDefaultHost(HONO_HTTP_ADAPTER_HOST);
        options.setDefaultPort(8080);
        this.httpClient = VERTX.createHttpClient(options);
        this.standardRequestHeaders = MultiMap.caseInsensitiveMultiMap().add(HttpHeaders.AUTHORIZATION, (CharSequence)HonoHttpDevice.getBasicAuth(TENANT_ID, DEVICE_AUTH_ID, DEVICE_PASSWORD)).add(HttpHeaders.ORIGIN, (CharSequence)ORIGIN_URI);
    }

    public static void main(String[] args) {
        HonoHttpDevice httpDevice = new HonoHttpDevice();
        httpDevice.sendData();
        VERTX.setTimer(2000L, timerId -> VERTX.close());
    }

    private CompletableFuture<Void> sendMessage(Request request) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        IntPredicate successfulStatus = statusCode -> statusCode >= 200 && statusCode < 300;
        HttpClientRequest req = this.httpClient.post(request.isEvent != false ? "/event" : "/telemetry").handler(response -> {
            System.out.println(response.statusCode() + " " + response.statusMessage());
            if (successfulStatus.test(response.statusCode())) {
                MultiMap resultMap = response.headers();
                resultMap.entries().stream().forEach(entry -> System.out.println(String.format("%s: %s", entry.getKey(), entry.getValue())));
                response.bodyHandler(b -> {
                    if (b.length() > 0) {
                        System.out.println();
                        System.out.println(b.toString());
                    }
                });
                String commandReqId = response.headers().get("hono-cmd-req-id");
                if (commandReqId == null) {
                    VERTX.setTimer(1000L, l -> result.complete(null));
                } else {
                    this.sendCommandResponse("text/plain", Buffer.buffer((String)"ok"), commandReqId, 200).map(status -> {
                        System.out.println(String.format("sent response to command [HTTP response status: %d]", status));
                        VERTX.setTimer(1000L, l -> result.complete(null));
                        return null;
                    });
                }
            } else {
                result.completeExceptionally((Throwable)new ServiceInvocationException(response.statusCode()));
            }
        }).exceptionHandler(t -> result.completeExceptionally((Throwable)t));
        req.headers().addAll(this.standardRequestHeaders);
        req.headers().addAll(request.getHeaders());
        if (request.payload == null) {
            req.end();
        } else {
            req.end(request.payload.encode());
        }
        return result;
    }

    private Future<Integer> sendCommandResponse(String contentType, Buffer payload, String commandReqId, int status) {
        Promise result = Promise.promise();
        HttpClientRequest req = this.httpClient.post(String.format("/%s/res/%s", "command", commandReqId)).handler(response -> result.complete((Object)response.statusCode()));
        req.putHeader("hono-cmd-status", Integer.toString(status));
        req.headers().addAll(this.standardRequestHeaders);
        if (payload == null) {
            req.end();
        } else {
            req.end(payload);
        }
        return result.future();
    }

    protected void sendData() {
        System.out.println(String.format("Total number of requests to send: %s", this.requests.size()));
        this.requests.stream().forEachOrdered(request -> {
            System.out.println();
            System.out.println();
            System.out.println(String.format("Sending request [type: %s] ...", request.toString()));
            CompletableFuture<Void> responseFuture = this.sendMessage((Request)((Object)request));
            try {
                responseFuture.join();
            }
            catch (CompletionException e) {
                System.err.println("error sending request to HTTP adapter: " + e.getMessage());
            }
        });
    }

    private static String getBasicAuth(String tenant, String deviceId, String password) {
        StringBuilder result = new StringBuilder("Basic ");
        String username = HonoHttpDevice.getUsername(deviceId, tenant);
        result.append(Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8)));
        return result.toString();
    }

    private static String getUsername(String deviceId, String tenant) {
        return String.format("%s@%s", deviceId, tenant);
    }

    private static enum Request {
        EmptyEventWithTtd(null, "application/vnd.eclipse-hono-empty-notification", 60, true),
        EmptyEventAlreadyInvalid(null, "application/vnd.eclipse-hono-empty-notification", 0, true),
        JsonEventWithoutTtd(new JsonObject().put("threshold", "exceeded"), "application/json", null, true),
        JsonEventWithTtd(new JsonObject().put("threshold", "exceeded"), "application/json", 120, true),
        TelemetryWithoutTtd(new JsonObject().put("weather", "sunny"), "application/json", null, false),
        TelemetryWithTtd(new JsonObject().put("weather", "cloudy"), "application/json", 60, false);

        private final JsonObject payload;
        private final String contentType;
        private final Integer ttd;
        private final Boolean isEvent;

        private Request(JsonObject payload, String contentType, Integer ttd, Boolean isEvent) {
            this.payload = payload;
            this.contentType = contentType;
            this.ttd = ttd;
            this.isEvent = isEvent;
        }

        public MultiMap getHeaders() {
            MultiMap headers = MultiMap.caseInsensitiveMultiMap();
            headers.add(HttpHeaders.CONTENT_TYPE, (CharSequence)this.contentType);
            if (this.ttd != null) {
                headers.add("hono-ttd", this.ttd.toString());
            }
            return headers;
        }

        public String toString() {
            return String.format("%s [content type: %s, ttd: %d, is event: %b, payload: %s]", this.name(), this.contentType, this.ttd, this.isEvent, this.payload);
        }
    }
}

