/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.devices;

import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.eclipse.hono.client.ServiceInvocationException;

public class HonoHttpDevice {
    public static final String HONO_HTTP_ADAPTER_HOST = "localhost";
    public static final int HONO_HTTP_ADAPTER_PORT = 8080;
    protected static final String ORIGIN_URI = "http://hono.eclipse.org";
    public static final String TENANT_ID = "DEFAULT_TENANT";
    public static final String DEVICE_AUTH_ID = "sensor1";
    public static final String DEVICE_PASSWORD = "hono-secret";
    final List<MessageTypes> messages = Arrays.asList(MessageTypes.EmptyEventWithTtd, MessageTypes.EmptyEventWithTtd, MessageTypes.EmptyEventWithTtd, MessageTypes.TelemetryWithoutTtd, MessageTypes.EmptyEventWithTtd, MessageTypes.TelemetryWithoutTtd, MessageTypes.JsonEventWithTtd, MessageTypes.TelemetryWithoutTtd, MessageTypes.JsonEventWithoutTtd, MessageTypes.EmptyEventAlreadyInvalid, MessageTypes.TelemetryWithTtd, MessageTypes.TelemetryWithoutTtd);
    private final Vertx vertx = Vertx.vertx();

    public static void main(String[] args) {
        HonoHttpDevice httpDevice = new HonoHttpDevice();
        httpDevice.sendData();
    }

    private CompletableFuture<MultiMap> sendMessage(JsonObject payload, MultiMap headersToAdd, boolean asEvent) {
        CompletableFuture<MultiMap> result = new CompletableFuture<MultiMap>();
        Predicate<Integer> successfulStatus = statusCode -> statusCode == 202;
        HttpClientRequest req = this.vertx.createHttpClient().post(8080, HONO_HTTP_ADAPTER_HOST, asEvent ? "/event" : "/telemetry").handler(response -> {
            if (successfulStatus.test(response.statusCode())) {
                this.vertx.setTimer(1000L, l -> result.complete(response.headers()));
            } else {
                result.completeExceptionally((Throwable)new ServiceInvocationException(response.statusCode()));
            }
        }).exceptionHandler(t -> result.completeExceptionally((Throwable)t));
        req.headers().addAll(headersToAdd);
        req.headers().addAll(MultiMap.caseInsensitiveMultiMap().add(HttpHeaders.AUTHORIZATION, (CharSequence)HonoHttpDevice.getBasicAuth(TENANT_ID, DEVICE_AUTH_ID, DEVICE_PASSWORD)).add(HttpHeaders.ORIGIN, (CharSequence)ORIGIN_URI));
        if (payload == null) {
            req.end();
        } else {
            req.end(payload.encode());
        }
        return result;
    }

    protected void sendData() {
        System.out.println(String.format("Total number of messages: %s", this.messages.size()));
        this.messages.stream().forEachOrdered(messageType -> {
            MultiMap headerMap = MultiMap.caseInsensitiveMultiMap();
            headerMap.add(HttpHeaders.CONTENT_TYPE, (CharSequence)((MessageTypes)messageType).contentType);
            Optional.ofNullable(((MessageTypes)messageType).ttd).ifPresent(timeToDeliver -> headerMap.add("hono-ttd", timeToDeliver.toString()));
            System.out.println(String.format("Sending message type %s", messageType.toString()));
            CompletableFuture<MultiMap> responseFuture = this.sendMessage(((MessageTypes)messageType).payload, headerMap, ((MessageTypes)messageType).isEvent);
            try {
                MultiMap resultMap = responseFuture.get();
                System.out.println(String.format("Got %d response keys.", resultMap.size()));
                resultMap.entries().stream().forEach(entry -> System.out.println(String.format("  %s:%s", entry.getKey(), entry.getValue())));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        });
        this.vertx.setTimer(2000L, timerId -> this.vertx.close());
    }

    private static String getBasicAuth(String tenant, String deviceId, String password) {
        StringBuilder result = new StringBuilder("Basic ");
        String username = HonoHttpDevice.getUsername(deviceId, tenant);
        result.append(Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8)));
        return result.toString();
    }

    private static String getUsername(String deviceId, String tenant) {
        return String.format("%s@%s", deviceId, tenant);
    }

    private static enum MessageTypes {
        EmptyEventWithTtd(null, "application/vnd.eclipse-hono-empty-notification", 60, true),
        EmptyEventAlreadyInvalid(null, "application/vnd.eclipse-hono-empty-notification", 0, true),
        JsonEventWithoutTtd(new JsonObject().put("anEventKey", "aValue"), "application/json", null, true),
        JsonEventWithTtd(new JsonObject().put("anEventKey", "aValue"), "application/json", 120, true),
        TelemetryWithoutTtd(new JsonObject().put("aTeleKey", "aValue"), "application/json", null, false),
        TelemetryWithTtd(new JsonObject().put("aTeleKey", "aValue"), "application/json", 60, false);

        private JsonObject payload;
        private String contentType;
        private Integer ttd;
        private Boolean isEvent;

        private MessageTypes(JsonObject payload, String contentType, Integer ttd, Boolean isEvent) {
            this.payload = payload;
            this.contentType = contentType;
            this.ttd = ttd;
            this.isEvent = isEvent;
        }

        public String toString() {
            return "MessageTypes{payload=" + this.payload + ", contentType='" + this.contentType + '\'' + ", ttd=" + this.ttd + ", isEvent=" + this.isEvent + '}';
        }
    }
}

