/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.example;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonClientOptions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.client.HonoClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;

abstract class AbstractExampleClient {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 200;
    protected Context ctx;
    @Value(value="${tenant.id}")
    protected String tenantId;
    protected Vertx vertx;
    protected HonoClient client;
    protected List<String> activeProfiles;

    protected AbstractExampleClient() {
    }

    @Autowired
    public final void setActiveProfiles(Environment env) {
        this.activeProfiles = Arrays.asList(env.getActiveProfiles());
    }

    @Autowired
    public final void setVertx(Vertx vertx) {
        this.vertx = vertx;
        this.ctx = vertx.getOrCreateContext();
    }

    @Autowired
    public final void setHonoClient(HonoClient client) {
        this.client = Objects.requireNonNull(client);
    }

    protected final ProtonClientOptions getClientOptions() {
        return new ProtonClientOptions().setConnectTimeout(200).setReconnectAttempts(1);
    }
}

