/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.example;

import io.vertx.core.Future;
import io.vertx.proton.ProtonClientOptions;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.example.AbstractExampleClient;
import org.eclipse.hono.util.MessageHelper;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!sender"})
public class ExampleReceiver
extends AbstractExampleClient {
    @PostConstruct
    private void start() {
        Future startupTracker = Future.future();
        startupTracker.setHandler(done -> {
            if (done.succeeded()) {
                this.LOG.info("Receiver created successfully.");
                this.vertx.executeBlocking(arg_0 -> this.waitForInput(arg_0), false, finish -> this.vertx.close());
            } else {
                this.LOG.error("Error occurred during initialization of message receiver: {}", (Object)done.cause().getMessage());
                this.vertx.close();
            }
        });
        this.ctx.runOnContext(go -> {
            Future connectionTracker = Future.future();
            this.client.connect(new ProtonClientOptions(), connectionTracker.completer());
            connectionTracker.compose(honoClient -> {
                if (this.activeProfiles.contains("event")) {
                    this.client.createEventConsumer(this.tenantId, msg -> this.handleMessage("event", msg), startupTracker.completer());
                } else {
                    this.client.createTelemetryConsumer(this.tenantId, msg -> this.handleMessage("telemetry", msg), startupTracker.completer());
                }
            }, startupTracker);
        });
    }

    private void waitForInput(Future<Object> f) {
        try {
            this.LOG.info("Press enter to stop receiver.");
            System.in.read();
            f.complete();
        }
        catch (IOException e) {
            this.LOG.error("problem reading message from STDIN", (Throwable)e);
            f.fail((Throwable)e);
        }
        finally {
            this.client.shutdown();
        }
    }

    private void handleMessage(String endpoint, Message msg) {
        String deviceId = MessageHelper.getDeviceId((Message)msg);
        Section body = msg.getBody();
        String content = null;
        if (body instanceof Data) {
            content = ((Data)msg.getBody()).getValue().toString();
        } else if (body instanceof AmqpValue) {
            content = ((AmqpValue)msg.getBody()).getValue().toString();
        }
        this.LOG.info("received {} message [device: {}, content-type: {}]: {}", new Object[]{endpoint, deviceId, msg.getContentType(), content});
        if (msg.getApplicationProperties() != null) {
            this.LOG.info("... with application properties: {}", (Object)msg.getApplicationProperties().getValue());
        }
    }
}

