/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.example;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonClientOptions;
import java.io.IOException;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.client.HonoClientConfigProperties;
import org.eclipse.hono.util.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!sender"})
public class ExampleReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(ExampleReceiver.class);
    @Value(value="${tenant.id}")
    private String tenantId;
    @Autowired
    private HonoClientConfigProperties clientConfig;
    @Autowired
    private Vertx vertx;
    private Context ctx;
    private HonoClient client;

    @PostConstruct
    private void start() {
        this.client = HonoClient.HonoClientBuilder.newClient((HonoClientConfigProperties)this.clientConfig).vertx(this.vertx).build();
        Future startupTracker = Future.future();
        startupTracker.setHandler(done -> {
            if (done.succeeded()) {
                LOG.info("Telemetry receiver created successfully.");
                this.vertx.executeBlocking(arg_0 -> this.waitForInput(arg_0), false, finish -> this.vertx.close());
            } else {
                LOG.error("Error occurred during initialization of telemetry receiver: {}", (Object)done.cause().getMessage());
                this.vertx.close();
            }
        });
        this.ctx = this.vertx.getOrCreateContext();
        this.ctx.runOnContext(go -> {
            Future connectionTracker = Future.future();
            this.client.connect(new ProtonClientOptions(), connectionTracker.completer());
            connectionTracker.compose(honoClient -> this.client.createTelemetryConsumer(this.tenantId, arg_0 -> this.handleMessage(arg_0), startupTracker.completer()), startupTracker);
        });
    }

    private void waitForInput(Future<Object> f) {
        try {
            LOG.info("Press enter to stop receiver.");
            System.in.read();
            f.complete();
        }
        catch (IOException e) {
            LOG.error("problem reading message from STDIN", (Throwable)e);
            f.fail((Throwable)e);
        }
        finally {
            this.client.shutdown();
        }
    }

    private void handleMessage(Message msg) {
        String deviceId = MessageHelper.getDeviceId((Message)msg);
        Section body = msg.getBody();
        String content = null;
        if (body instanceof Data) {
            content = ((Data)msg.getBody()).getValue().toString();
        } else if (body instanceof AmqpValue) {
            content = ((AmqpValue)msg.getBody()).getValue().toString();
        }
        LOG.info("received telemetry message [device: {}, content-type: {}]: {}", new Object[]{deviceId, msg.getContentType(), content});
        if (msg.getApplicationProperties() != null) {
            Map props = msg.getApplicationProperties().getValue();
            LOG.info("... with application properties: {}", (Object)props);
        }
    }
}

