/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.devices;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.amqp.config.ClientConfigProperties;
import org.eclipse.hono.client.amqp.connection.AmqpUtils;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.eclipse.hono.client.device.amqp.AmqpAdapterClient;
import org.eclipse.hono.util.QoS;

@SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="We use the default passwords of the Hono Sandbox installation throughout this class\nfor ease of use. The passwords are publicly documented and do not affect any\nprivate installations of Hono.\n")
public class AmqpExampleDevice {
    private static final String HOST = "hono.eclipseprojects.io";
    private static final int PORT = 5671;
    private static final boolean TLS_ENABLED = true;
    private static final int RECONNECT_ATTEMPTS = 1;
    private static final String TENANT_ID = "DEFAULT_TENANT";
    private static final String AUTH_ID = "sensor1";
    private static final String PASSWORD = "hono-secret";
    private final Vertx vertx = Vertx.vertx();
    private final ClientConfigProperties config = new ClientConfigProperties();
    private AmqpAdapterClient client;

    private AmqpExampleDevice() {
        this.config.setHost(HOST);
        this.config.setPort(5671);
        this.config.setTlsEnabled(true);
        this.config.setUsername("sensor1@DEFAULT_TENANT");
        this.config.setPassword(PASSWORD);
        this.config.setReconnectAttempts(1);
    }

    public static void main(String[] args) {
        AmqpExampleDevice amqpExampleDevice = new AmqpExampleDevice();
        amqpExampleDevice.connect();
    }

    private void connect() {
        HonoConnection connection = HonoConnection.newConnection((Vertx)this.vertx, (ClientConfigProperties)this.config);
        connection.connect().onSuccess(this::startDevice).onFailure(t -> {
            System.err.println("Failed to establish connection: " + String.valueOf(t));
            System.exit(1);
        });
    }

    private void startDevice(HonoConnection connection) {
        this.client = AmqpAdapterClient.create((HonoConnection)connection);
        this.sendTelemetryMessageWithQos0();
        this.vertx.setTimer(1000L, l -> this.sendTelemetryMessageWithQos1());
        this.vertx.setTimer(2000L, l -> this.sendEvent());
        this.vertx.setTimer(3000L, l -> {
            System.out.println("Waiting for commands... (Press Ctrl+C to stop)");
            this.client.createCommandConsumer(this::handleCommand);
        });
    }

    private void sendTelemetryMessageWithQos0() {
        System.out.println();
        String payload = "42";
        this.client.sendTelemetry(QoS.AT_MOST_ONCE, Buffer.buffer((String)"42"), "text/plain", null, null, null).onSuccess(delivery -> System.out.println("Telemetry message with QoS 'AT_MOST_ONCE' sent: 42")).onFailure(t -> System.err.println("Sending telemetry message with QoS 'AT_MOST_ONCE' failed: " + String.valueOf(t)));
    }

    private void sendTelemetryMessageWithQos1() {
        JsonObject payload = new JsonObject().put("weather", (Object)"cloudy");
        this.client.sendTelemetry(QoS.AT_LEAST_ONCE, payload.toBuffer(), "application/json", null, null, null).onSuccess(delivery -> System.out.println("Telemetry message with QoS 'AT_LEAST_ONCE' sent: " + String.valueOf(payload))).onFailure(t -> {
            String hint = "";
            if (ServiceInvocationException.extractStatusCode((Throwable)t) == 503) {
                hint = " (Is there a consumer connected?)";
            }
            System.err.println("Sending telemetry message with QoS 'AT_LEAST_ONCE' failed: " + String.valueOf(t) + hint);
        });
    }

    private void sendEvent() {
        JsonObject payload = new JsonObject().put("threshold", (Object)"exceeded");
        this.client.sendEvent(payload.toBuffer(), "application/json", null, null, null).onSuccess(delivery -> System.out.println("Event sent: " + String.valueOf(payload))).onFailure(t -> System.err.println("Sending event failed: " + String.valueOf(t)));
    }

    private void handleCommand(Message commandMessage) {
        String subject = commandMessage.getSubject();
        String commandPayload = AmqpUtils.getPayloadAsString((Message)commandMessage);
        if (commandMessage.getReplyTo() == null || commandMessage.getCorrelationId() == null) {
            System.out.println(String.format("Received one-way command [name: %s]: %s", subject, commandPayload));
        } else {
            System.out.println(String.format("Received command [name: %s]: %s", subject, commandPayload));
            this.sendCommandResponse(commandMessage);
        }
    }

    private void sendCommandResponse(Message command) {
        JsonObject payload = new JsonObject().put("outcome", (Object)"success");
        this.client.sendCommandResponse(command.getReplyTo(), command.getCorrelationId().toString(), 200, payload.toBuffer(), "application/json", null).onSuccess(delivery -> System.out.println("Command response sent: " + String.valueOf(payload))).onFailure(t -> System.err.println("Sending command response failed: " + String.valueOf(t)));
    }
}

