/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.pubsub.tracing;

import com.google.pubsub.v1.PubsubMessage;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopSpanContext;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.client.pubsub.tracing.PubSubMessageExtractAdapter;

public final class PubSubTracingHelper {
    private PubSubTracingHelper() {
    }

    public static void injectSpanContext(Tracer tracer, Map<String, String> attributes, SpanContext spanContext) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(attributes);
        if (spanContext != null && !(spanContext instanceof NoopSpanContext)) {
            tracer.inject(spanContext, Format.Builtin.TEXT_MAP, (Object)new TextMapAdapter(attributes));
        }
    }

    public static SpanContext extractSpanContext(Tracer tracer, PubsubMessage message) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(message);
        return tracer.extract(Format.Builtin.TEXT_MAP, (Object)new PubSubMessageExtractAdapter(message));
    }
}

