/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.pubsub.subscriber;

import com.google.api.gax.core.CredentialsProvider;
import com.google.cloud.pubsub.v1.MessageReceiver;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.pubsub.PubSubMessageHelper;
import org.eclipse.hono.client.pubsub.subscriber.PubSubSubscriberClient;
import org.eclipse.hono.client.pubsub.subscriber.PubSubSubscriberClientImpl;
import org.eclipse.hono.client.pubsub.subscriber.PubSubSubscriberFactory;

public class CachingPubSubSubscriberFactory
implements PubSubSubscriberFactory {
    private final Vertx vertx;
    private final Map<String, PubSubSubscriberClient> activeSubscribers = new ConcurrentHashMap<String, PubSubSubscriberClient>();
    private final String projectId;
    private final CredentialsProvider credentialsProvider;
    private Supplier<PubSubSubscriberClient> clientSupplier;

    public CachingPubSubSubscriberFactory(Vertx vertx, String projectId, CredentialsProvider credentialsProvider) {
        this.vertx = Objects.requireNonNull(vertx);
        this.projectId = Objects.requireNonNull(projectId);
        this.credentialsProvider = Objects.requireNonNull(credentialsProvider);
    }

    public void setClientSupplier(Supplier<PubSubSubscriberClient> supplier) {
        this.clientSupplier = supplier;
    }

    @Override
    public Future<Void> closeSubscriber(String subscription, String prefix) {
        String subscriptionId = PubSubMessageHelper.getTopicName(subscription, prefix);
        return this.removeSubscriber(subscriptionId);
    }

    @Override
    public Future<Void> closeAllSubscribers() {
        this.activeSubscribers.forEach((k, v) -> this.removeSubscriber((String)k));
        if (this.activeSubscribers.isEmpty()) {
            return Future.succeededFuture();
        }
        return Future.failedFuture((Throwable)new ServerErrorException(503, "Failed to close all subscriber"));
    }

    @Override
    public PubSubSubscriberClient getOrCreateSubscriber(String subscriptionId, MessageReceiver receiver) {
        return this.activeSubscribers.computeIfAbsent(subscriptionId, s -> this.createPubSubSubscriber(subscriptionId, receiver));
    }

    @Override
    public Optional<PubSubSubscriberClient> getSubscriber(String subscription, String prefix) {
        String subscriptionId = PubSubMessageHelper.getTopicName(subscription, prefix);
        return Optional.ofNullable(this.activeSubscribers.get(subscriptionId));
    }

    private PubSubSubscriberClient createPubSubSubscriber(String subscriptionId, MessageReceiver receiver) {
        return Optional.ofNullable(this.clientSupplier).map(Supplier::get).orElseGet(() -> new PubSubSubscriberClientImpl(this.vertx, this.projectId, subscriptionId, receiver, this.credentialsProvider));
    }

    private Future<Void> removeSubscriber(String subscriptionId) {
        PubSubSubscriberClient subscriber = this.activeSubscribers.remove(subscriptionId);
        if (subscriber != null) {
            try {
                subscriber.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Future.succeededFuture();
    }
}

