/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.pubsub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.protobuf.util.Durations;
import com.google.pubsub.v1.ExpirationPolicy;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.SubscriptionName;
import com.google.pubsub.v1.TopicName;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.hono.client.pubsub.PubSubConfigProperties;
import org.eclipse.hono.client.pubsub.PubSubMessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubSubBasedAdminClientManager {
    private static final Logger LOG = LoggerFactory.getLogger(PubSubBasedAdminClientManager.class);
    private static final long MESSAGE_RETENTION = 600000L;
    private final String projectId;
    private final CredentialsProvider credentialsProvider;
    private final Vertx vertx;
    private SubscriptionAdminClient subscriptionAdminClient;
    private TopicAdminClient topicAdminClient;

    public PubSubBasedAdminClientManager(PubSubConfigProperties pubSubConfigProperties, CredentialsProvider credentialsProvider, Vertx vertx) {
        Objects.requireNonNull(pubSubConfigProperties);
        this.projectId = Objects.requireNonNull(pubSubConfigProperties.getProjectId());
        this.credentialsProvider = Objects.requireNonNull(credentialsProvider);
        this.vertx = Objects.requireNonNull(vertx);
    }

    private Future<TopicAdminClient> getOrCreateTopicAdminClient() {
        if (this.topicAdminClient != null) {
            return Future.succeededFuture((Object)this.topicAdminClient);
        }
        try {
            TopicAdminSettings adminSettings = ((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).build();
            this.topicAdminClient = TopicAdminClient.create((TopicAdminSettings)adminSettings);
            return Future.succeededFuture((Object)this.topicAdminClient);
        }
        catch (IOException e) {
            LOG.debug("Error initializing topic admin client: {}", (Object)e.getMessage());
            return Future.failedFuture((String)"Error creating client");
        }
    }

    private Future<SubscriptionAdminClient> getOrCreateSubscriptionAdminClient() {
        if (this.subscriptionAdminClient != null) {
            return Future.succeededFuture((Object)this.subscriptionAdminClient);
        }
        try {
            SubscriptionAdminSettings adminSettings = ((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).build();
            this.subscriptionAdminClient = SubscriptionAdminClient.create((SubscriptionAdminSettings)adminSettings);
            return Future.succeededFuture((Object)this.subscriptionAdminClient);
        }
        catch (IOException e) {
            LOG.debug("Error initializing subscription admin client: {}", (Object)e.getMessage());
            return Future.failedFuture((String)"Error creating client");
        }
    }

    public Future<String> getOrCreateTopic(String endpoint, String prefix) {
        TopicName topicName = TopicName.of((String)this.projectId, (String)PubSubMessageHelper.getTopicName(endpoint, prefix));
        return this.getOrCreateTopicAdminClient().onFailure(thr -> LOG.debug("admin client creation failed", thr)).compose(client -> this.getTopic(topicName, (TopicAdminClient)client).recover(thr -> {
            if (thr instanceof NotFoundException) {
                return this.createTopic(topicName, (TopicAdminClient)client);
            }
            return Future.failedFuture((Throwable)thr);
        }));
    }

    private Future<String> getTopic(TopicName topicName, TopicAdminClient client) {
        return this.vertx.executeBlocking(() -> client.getTopic(topicName).getName());
    }

    private Future<String> createTopic(TopicName topicName, TopicAdminClient client) {
        return this.vertx.executeBlocking(() -> client.createTopic(topicName).getName()).onSuccess(top -> LOG.debug("Topic {} created successfully.", (Object)topicName)).onFailure(thr -> LOG.debug("Creating topic failed [topic: {}, projectId: {}]", (Object)topicName, (Object)this.projectId));
    }

    public Future<String> getOrCreateSubscription(String endpoint, String prefix) {
        String topicAndSubscriptionName = PubSubMessageHelper.getTopicName(endpoint, prefix);
        TopicName topicName = TopicName.of((String)this.projectId, (String)topicAndSubscriptionName);
        SubscriptionName subscriptionName = SubscriptionName.of((String)this.projectId, (String)topicAndSubscriptionName);
        return this.getOrCreateSubscriptionAdminClient().onFailure(thr -> LOG.debug("admin client creation failed", thr)).compose(client -> this.getSubscription(subscriptionName, (SubscriptionAdminClient)client).recover(thr -> {
            if (thr instanceof NotFoundException) {
                return this.createSubscription(subscriptionName, topicName, (SubscriptionAdminClient)client);
            }
            return Future.failedFuture((Throwable)thr);
        }));
    }

    private Future<String> getSubscription(SubscriptionName subscriptionName, SubscriptionAdminClient client) {
        return this.vertx.executeBlocking(() -> client.getSubscription(subscriptionName).getName());
    }

    private Future<String> createSubscription(SubscriptionName subscriptionName, TopicName topicName, SubscriptionAdminClient client) {
        Subscription request = Subscription.newBuilder().setName(subscriptionName.toString()).setTopic(topicName.toString()).setPushConfig(PushConfig.getDefaultInstance()).setAckDeadlineSeconds(0).setMessageRetentionDuration(Durations.fromMillis((long)600000L)).setExpirationPolicy(ExpirationPolicy.getDefaultInstance()).build();
        return this.vertx.executeBlocking(() -> client.createSubscription(request).getName()).onSuccess(sub -> LOG.debug("Subscription {} created successfully.", (Object)subscriptionName)).onFailure(thr -> LOG.debug("Creating subscription failed [subscription: {}, topic: {}, project: {}]", new Object[]{subscriptionName, topicName, this.projectId}));
    }

    public void closeAdminClients() {
        if (this.topicAdminClient == null && this.subscriptionAdminClient == null) {
            return;
        }
        this.vertx.executeBlocking(() -> {
            this.closeSubscriptionAdminClient();
            this.closeTopicAdminClient();
            return null;
        });
    }

    private void closeSubscriptionAdminClient() {
        if (this.subscriptionAdminClient != null) {
            this.subscriptionAdminClient.shutdown();
            try {
                this.subscriptionAdminClient.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.debug("Resources are not freed properly, error", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void closeTopicAdminClient() {
        if (this.topicAdminClient != null) {
            this.topicAdminClient.shutdown();
            try {
                this.topicAdminClient.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.debug("Resources are not freed properly, error", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

