/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.pubsub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.AlreadyExistsException;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.protobuf.util.Durations;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.SubscriptionName;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import io.vertx.core.Future;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.hono.client.pubsub.PubSubMessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubSubBasedAdminClientManager {
    private static final Logger LOG = LoggerFactory.getLogger(PubSubBasedAdminClientManager.class);
    private static final long MESSAGE_RETENTION = 600000L;
    private final String projectId;
    private final Set<String> subscriptions = new HashSet<String>();
    private final Set<String> topics = new HashSet<String>();
    private final CredentialsProvider credentialsProvider;
    private SubscriptionAdminClient subscriptionAdminClient;
    private TopicAdminClient topicAdminClient;

    public PubSubBasedAdminClientManager(String projectId, CredentialsProvider credentialsProvider) {
        this.projectId = Objects.requireNonNull(projectId);
        this.credentialsProvider = Objects.requireNonNull(credentialsProvider);
    }

    private Future<TopicAdminClient> getOrCreateTopicAdminClient() {
        if (this.topicAdminClient != null) {
            return Future.succeededFuture((Object)this.topicAdminClient);
        }
        try {
            TopicAdminSettings adminSettings = ((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).build();
            this.topicAdminClient = TopicAdminClient.create((TopicAdminSettings)adminSettings);
            return Future.succeededFuture((Object)this.topicAdminClient);
        }
        catch (IOException e) {
            LOG.debug("Error initializing topic admin client: {}", (Object)e.getMessage());
            return Future.failedFuture((String)"Error creating client");
        }
    }

    private Future<SubscriptionAdminClient> getOrCreateSubscriptionAdminClient() {
        if (this.subscriptionAdminClient != null) {
            return Future.succeededFuture((Object)this.subscriptionAdminClient);
        }
        try {
            SubscriptionAdminSettings adminSettings = ((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).build();
            this.subscriptionAdminClient = SubscriptionAdminClient.create((SubscriptionAdminSettings)adminSettings);
            return Future.succeededFuture((Object)this.subscriptionAdminClient);
        }
        catch (IOException e) {
            LOG.debug("Error initializing subscription admin client: {}", (Object)e.getMessage());
            return Future.failedFuture((String)"Error creating client");
        }
    }

    public Future<String> getOrCreateTopic(String endpoint, String prefix) {
        String topicName = PubSubMessageHelper.getTopicName(endpoint, prefix);
        TopicName topic = TopicName.of((String)this.projectId, (String)topicName);
        if (this.topics.contains(topic.toString())) {
            LOG.debug("Topic {} already exists, continue", (Object)topic);
            return Future.succeededFuture((Object)topic.getTopic());
        }
        return this.getOrCreateTopicAdminClient().onFailure(thr -> LOG.debug("admin client creation failed", thr)).compose(client -> this.getOrCreateTopic(this.projectId, topic, (TopicAdminClient)client));
    }

    private Future<String> getOrCreateTopic(String projectId, TopicName topic, TopicAdminClient client) {
        try {
            Topic createdTopic = client.createTopic(topic);
            if (createdTopic == null) {
                LOG.debug("Creating topic failed [topic: {}, projectId: {}]", (Object)topic, (Object)projectId);
                return Future.failedFuture((String)"Topic creation failed.");
            }
            this.topics.add(createdTopic.getName());
            return Future.succeededFuture((Object)topic.getTopic());
        }
        catch (AlreadyExistsException ex) {
            return Future.succeededFuture((Object)topic.getTopic());
        }
        catch (ApiException e) {
            LOG.debug("Error creating topic {} on project {}", new Object[]{topic, projectId, e});
            return Future.failedFuture((String)"Topic creation failed.");
        }
    }

    public Future<String> getOrCreateSubscription(String endpoint, String prefix) {
        String topicAndSubscriptionName = PubSubMessageHelper.getTopicName(endpoint, prefix);
        TopicName topic = TopicName.of((String)this.projectId, (String)topicAndSubscriptionName);
        SubscriptionName subscription = SubscriptionName.of((String)this.projectId, (String)topicAndSubscriptionName);
        if (this.subscriptions.contains(subscription.toString())) {
            LOG.debug("Subscription {} already exists, continue", (Object)subscription);
            return Future.succeededFuture((Object)subscription.getSubscription());
        }
        return this.getOrCreateSubscriptionAdminClient().onFailure(thr -> LOG.debug("admin client creation failed", thr)).compose(client -> this.getOrCreateSubscription(this.projectId, subscription, topic, (SubscriptionAdminClient)client));
    }

    private Future<String> getOrCreateSubscription(String projectId, SubscriptionName subscription, TopicName topic, SubscriptionAdminClient client) {
        try {
            Subscription request = Subscription.newBuilder().setName(subscription.toString()).setTopic(topic.toString()).setPushConfig(PushConfig.getDefaultInstance()).setAckDeadlineSeconds(0).setMessageRetentionDuration(Durations.fromMillis((long)600000L)).build();
            Subscription createdSubscription = client.createSubscription(request);
            if (createdSubscription == null) {
                LOG.debug("Creating subscription failed [subscription: {}, topic: {}, project: {}]", new Object[]{subscription, topic, projectId});
                return Future.failedFuture((String)"Subscription creation failed.");
            }
            this.subscriptions.add(createdSubscription.getName());
            return Future.succeededFuture((Object)subscription.getSubscription());
        }
        catch (AlreadyExistsException ex) {
            return Future.succeededFuture((Object)subscription.getSubscription());
        }
        catch (ApiException e) {
            LOG.debug("Error creating subscription {} for topic {} on project {}", new Object[]{subscription, topic, projectId, e});
            return Future.failedFuture((String)"Subscription creation failed.");
        }
    }

    public void closeAdminClients() {
        if (this.topicAdminClient == null && this.subscriptionAdminClient == null) {
            return;
        }
        this.closeSubscriptionAdminClient();
        this.closeTopicAdminClient();
    }

    private void closeSubscriptionAdminClient() {
        if (this.subscriptionAdminClient != null) {
            this.subscriptionAdminClient.shutdown();
            try {
                this.subscriptionAdminClient.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.debug("Resources are not freed properly, error", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void closeTopicAdminClient() {
        if (this.topicAdminClient != null) {
            this.topicAdminClient.shutdown();
            try {
                this.topicAdminClient.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.debug("Resources are not freed properly, error", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

