/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.pubsub;

import com.google.api.gax.core.CredentialsProvider;
import io.vertx.core.Future;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.pubsub.PubSubPublisherClient;
import org.eclipse.hono.client.pubsub.PubSubPublisherClientImpl;
import org.eclipse.hono.client.pubsub.PubSubPublisherFactory;

public final class CachingPubSubPublisherFactory
implements PubSubPublisherFactory {
    private final Map<String, PubSubPublisherClient> activePublishers = new ConcurrentHashMap<String, PubSubPublisherClient>();
    private final String projectId;
    private final CredentialsProvider credentialsProvider;
    private Supplier<PubSubPublisherClient> clientSupplier;

    public CachingPubSubPublisherFactory(String projectId, CredentialsProvider credentialsProvider) {
        this.projectId = Objects.requireNonNull(projectId);
        this.credentialsProvider = credentialsProvider;
    }

    public void setClientSupplier(Supplier<PubSubPublisherClient> supplier) {
        this.clientSupplier = supplier;
    }

    @Override
    public Future<Void> closePublisher(String topic, String tenantId) {
        String topicName = this.getTopicTenantName(topic, tenantId);
        return this.removePublisher(topicName);
    }

    @Override
    public Future<Void> closeAllPublisher() {
        this.activePublishers.forEach((k, v) -> this.removePublisher((String)k));
        if (this.activePublishers.size() == 0) {
            return Future.succeededFuture();
        }
        return Future.failedFuture((Throwable)new ServerErrorException(503, "Failed to close all publisher"));
    }

    @Override
    public PubSubPublisherClient getOrCreatePublisher(String topic, String tenantId) {
        String topicName = this.getTopicTenantName(topic, tenantId);
        return this.activePublishers.computeIfAbsent(topicName, s -> this.getPubSubPublisherClient(this.projectId, topicName));
    }

    @Override
    public Optional<PubSubPublisherClient> getPublisher(String topic, String tenantId) {
        String topicTenantName = this.getTopicTenantName(topic, tenantId);
        return Optional.ofNullable(this.activePublishers.get(topicTenantName));
    }

    private PubSubPublisherClient getPubSubPublisherClient(String projectId, String topic) {
        return Optional.ofNullable(this.clientSupplier).map(Supplier::get).orElseGet(() -> new PubSubPublisherClientImpl(projectId, topic, this.credentialsProvider));
    }

    private String getTopicTenantName(String topic, String tenantId) {
        return String.format("%s.%s", tenantId, topic);
    }

    private Future<Void> removePublisher(String topicName) {
        PubSubPublisherClient publisher = this.activePublishers.remove(topicName);
        if (publisher != null) {
            try {
                publisher.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Future.succeededFuture();
    }
}

