/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.notification.deviceregistry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.hono.annotation.HonoTimestamp;
import org.eclipse.hono.notification.AbstractNotification;
import org.eclipse.hono.notification.NotificationType;
import org.eclipse.hono.notification.deviceregistry.LifecycleChange;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class TenantChangeNotification
extends AbstractNotification {
    public static final String TYPE_NAME = "tenant-change-v1";
    public static final String ADDRESS = "registry-tenant";
    public static final NotificationType<TenantChangeNotification> TYPE = new NotificationType<TenantChangeNotification>("tenant-change-v1", TenantChangeNotification.class, "registry-tenant");
    private final LifecycleChange change;
    private final String tenantId;
    private final boolean enabled;

    @JsonCreator
    TenantChangeNotification(@JsonProperty(value="source", required=true) String source, @JsonProperty(value="creation-time", required=true) @HonoTimestamp Instant creationTime, @JsonProperty(value="change", required=true) LifecycleChange change, @JsonProperty(value="tenant-id", required=true) String tenantId, @JsonProperty(value="enabled", required=true) boolean enabled) {
        super(source, creationTime);
        this.change = Objects.requireNonNull(change);
        this.tenantId = Objects.requireNonNull(tenantId);
        this.enabled = enabled;
    }

    public TenantChangeNotification(LifecycleChange change, String tenantId, Instant creationTime, boolean enabled) {
        this("device-registry", creationTime, change, tenantId, enabled);
    }

    @JsonProperty(value="change")
    public LifecycleChange getChange() {
        return this.change;
    }

    @JsonProperty(value="tenant-id")
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonIgnore
    public NotificationType<TenantChangeNotification> getType() {
        return TYPE;
    }

    @Override
    @JsonIgnore
    public String getKey() {
        return this.getTenantId();
    }

    public String toString() {
        return "TenantChangeNotification{change=" + this.change + ", tenantId='" + this.tenantId + "', enabled=" + this.enabled + ", creationTime='" + this.getCreationTime() + "'}";
    }
}

