/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.notification;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import org.eclipse.hono.notification.AbstractNotification;
import org.eclipse.hono.notification.NotificationConstants;
import org.eclipse.hono.notification.NotificationType;

public final class NotificationTypeResolver
extends TypeIdResolverBase {
    private JavaType baseType;

    public void init(JavaType baseType) {
        this.baseType = baseType;
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    public String idFromValue(Object obj) {
        return this.idFromValueAndType(obj, obj.getClass());
    }

    public String idFromValueAndType(Object obj, Class<?> subType) {
        if (obj instanceof AbstractNotification) {
            return ((AbstractNotification)obj).getType().getTypeName();
        }
        return null;
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        for (NotificationType<?> type : NotificationConstants.DEVICE_REGISTRY_NOTIFICATION_TYPES) {
            if (!type.getTypeName().equals(id)) continue;
            return context.constructSpecializedType(this.baseType, type.getClazz());
        }
        return null;
    }
}

