/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.notification;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.hono.annotation.HonoTimestamp;
import org.eclipse.hono.notification.NotificationType;
import org.eclipse.hono.notification.NotificationTypeResolver;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true)
@JsonTypeIdResolver(value=NotificationTypeResolver.class)
public abstract class AbstractNotification {
    private final String source;
    private final Instant creationTime;

    protected AbstractNotification(String source, Instant creationTime) {
        this.source = Objects.requireNonNull(source);
        this.creationTime = Objects.requireNonNull(creationTime);
    }

    public abstract NotificationType<? extends AbstractNotification> getType();

    public abstract String getKey();

    @JsonGetter(value="source")
    public final String getSource() {
        return this.source;
    }

    @JsonGetter(value="creation-time")
    @HonoTimestamp
    public final Instant getCreationTime() {
        return this.creationTime;
    }
}

