/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class AnnotatedCacheKey<T> {
    private final T key;
    private final Map<String, String> attributes = new HashMap<String, String>();

    public AnnotatedCacheKey(T key) {
        this.key = Objects.requireNonNull(key);
    }

    public T getKey() {
        return this.key;
    }

    public void putAttribute(String attributeKey, String value) {
        Objects.requireNonNull(attributeKey);
        Objects.requireNonNull(value);
        this.attributes.put(attributeKey, value);
    }

    public Optional<String> getAttribute(String attributeKey) {
        Objects.requireNonNull(attributeKey);
        return Optional.ofNullable(this.attributes.get(attributeKey));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotatedCacheKey that = (AnnotatedCacheKey)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public String toString() {
        return "AnnotatedCacheKey{key=" + String.valueOf(this.key) + ", attributes=" + String.valueOf(this.attributes) + "}";
    }
}

