/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.util;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.hono.client.ServerErrorException;

public class ClientFactory<T> {
    protected final List<Handler<Void>> creationRequests = new ArrayList<Handler<Void>>();

    public final void clearState() {
        this.failAllCreationRequests();
        this.doClearState();
    }

    private void failAllCreationRequests() {
        Iterator<Handler<Void>> iter = this.creationRequests.iterator();
        while (iter.hasNext()) {
            iter.next().handle(null);
            iter.remove();
        }
    }

    protected void doClearState() {
    }

    public final void createClient(Supplier<Future<T>> clientSupplier, Handler<AsyncResult<T>> result) {
        Handler connectionFailureHandler = connectionLost -> result.handle((Object)Future.failedFuture((Throwable)new ServerErrorException(503, "connection to server lost")));
        this.creationRequests.add((Handler<Void>)connectionFailureHandler);
        clientSupplier.get().onComplete(attempt -> {
            this.creationRequests.remove(connectionFailureHandler);
            result.handle(attempt);
        });
    }
}

