/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.util;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.hono.client.util.ServiceClient;
import org.eclipse.hono.util.Lifecycle;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.TenantObject;

public final class MessagingClient<T extends Lifecycle>
implements Lifecycle,
ServiceClient {
    public static final MessagingType DEFAULT_MESSAGING_TYPE = MessagingType.amqp;
    private final Map<MessagingType, T> clientImplementations = new HashMap<MessagingType, T>();

    private void requireClientsConfigured() {
        if (!this.containsImplementations()) {
            throw new IllegalStateException("no messaging client configured");
        }
    }

    public boolean containsImplementations() {
        return !this.clientImplementations.isEmpty();
    }

    public MessagingClient<T> setClient(MessagingType type, T client) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(client);
        this.clientImplementations.put(type, client);
        return this;
    }

    public T getClient(TenantObject tenant) {
        Objects.requireNonNull(tenant);
        this.requireClientsConfigured();
        return (T)Optional.ofNullable((JsonObject)tenant.getProperty("ext", JsonObject.class)).map(ext -> ext.getString("messaging-type")).map(type -> (Lifecycle)this.clientImplementations.get(MessagingType.valueOf((String)type))).orElseGet(this::getDefaultImplementation);
    }

    public T getClient(String messagingType) {
        this.requireClientsConfigured();
        return (T)Optional.ofNullable(messagingType).map(MessagingType::valueOf).map(this.clientImplementations::get).orElseGet(this::getDefaultImplementation);
    }

    private T getDefaultImplementation() {
        if (this.clientImplementations.size() == 1) {
            return (T)((Lifecycle)this.clientImplementations.values().iterator().next());
        }
        return (T)((Lifecycle)this.clientImplementations.get(DEFAULT_MESSAGING_TYPE));
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        this.clientImplementations.values().stream().filter(ServiceClient.class::isInstance).map(ServiceClient.class::cast).forEach(client -> client.registerReadinessChecks(readinessHandler));
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
        this.clientImplementations.values().stream().filter(ServiceClient.class::isInstance).map(ServiceClient.class::cast).forEach(client -> client.registerLivenessChecks(livenessHandler));
    }

    public Future<Void> start() {
        this.requireClientsConfigured();
        List futures = this.clientImplementations.values().stream().map(Lifecycle::start).collect(Collectors.toList());
        return CompositeFuture.all(futures).mapEmpty();
    }

    public Future<Void> stop() {
        List futures = this.clientImplementations.values().stream().map(Lifecycle::stop).collect(Collectors.toList());
        return CompositeFuture.all(futures).mapEmpty();
    }
}

