/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.pubsub;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.InternalCommandSender;
import org.eclipse.hono.client.command.pubsub.PubSubBasedCommand;
import org.eclipse.hono.client.pubsub.AbstractPubSubBasedMessageSender;
import org.eclipse.hono.client.pubsub.PubSubMessageHelper;
import org.eclipse.hono.client.pubsub.publisher.PubSubPublisherFactory;

public class PubSubBasedInternalCommandSender
extends AbstractPubSubBasedMessageSender
implements InternalCommandSender {
    public PubSubBasedInternalCommandSender(PubSubPublisherFactory publisherFactory, String projectId, Tracer tracer) {
        super(publisherFactory, "command_internal", projectId, tracer);
    }

    public Future<Void> sendCommand(CommandContext commandContext, String adapterInstanceId) {
        Objects.requireNonNull(commandContext);
        Objects.requireNonNull(adapterInstanceId);
        Command command = commandContext.getCommand();
        if (!(command instanceof PubSubBasedCommand)) {
            commandContext.release();
            this.log.error("command is not an instance of PubSubBasedCommand");
            throw new IllegalArgumentException("command is not an instance of PubSubBasedCommand");
        }
        Span span = this.startSpan("delegate Command request", command.getTenant(), command.getDeviceId(), "child_of", commandContext.getTracingContext());
        String topic = PubSubMessageHelper.getTopicName((String)"command_internal", (String)adapterInstanceId);
        return this.sendAndWaitForOutcome(topic, command.getTenant(), command.getDeviceId(), command.getPayload(), this.getAttributes((PubSubBasedCommand)command), span).onSuccess(v -> commandContext.accept()).onFailure(thr -> commandContext.release((Throwable)new ServerErrorException(command.getTenant(), 503, "failed to publish command message on internal command topic", thr))).onComplete(ar -> span.finish());
    }

    private Map<String, Object> getAttributes(PubSubBasedCommand command) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(command.getPubsubMessage().getAttributesMap());
        attributes.put("tenant_id", command.getTenant());
        attributes.put("device_id", command.getDeviceId());
        attributes.put("projectId", this.projectId);
        attributes.put("response-required", !command.isOneWay());
        Optional.ofNullable(command.getGatewayId()).ifPresent(id -> attributes.put("gateway_id", id));
        return attributes;
    }
}

