/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.pubsub;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.client.command.CommandResponse;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.client.pubsub.AbstractPubSubBasedMessageSender;
import org.eclipse.hono.client.pubsub.PubSubMessageHelper;
import org.eclipse.hono.client.pubsub.publisher.PubSubPublisherFactory;
import org.eclipse.hono.client.util.DownstreamMessageProperties;
import org.eclipse.hono.notification.NotificationEventBusSupport;
import org.eclipse.hono.notification.NotificationType;
import org.eclipse.hono.notification.deviceregistry.LifecycleChange;
import org.eclipse.hono.notification.deviceregistry.TenantChangeNotification;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.TenantObject;

public class PubSubBasedCommandResponseSender
extends AbstractPubSubBasedMessageSender
implements CommandResponseSender {
    public PubSubBasedCommandResponseSender(Vertx vertx, PubSubPublisherFactory publisherFactory, String projectId, Tracer tracer) {
        super(publisherFactory, "command_response", projectId, tracer);
        Objects.requireNonNull(vertx);
        NotificationEventBusSupport.registerConsumer((Vertx)vertx, (NotificationType)TenantChangeNotification.TYPE, notification -> {
            if (LifecycleChange.DELETE.equals((Object)notification.getChange())) {
                publisherFactory.getPublisher("command_response", notification.getTenantId()).ifPresent(publisher -> publisherFactory.closePublisher("command_response", notification.getTenantId()));
            }
        });
    }

    public Future<Void> sendCommandResponse(TenantObject tenant, RegistrationAssertion device, CommandResponse response, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(device);
        Objects.requireNonNull(response);
        if (this.log.isTraceEnabled()) {
            this.log.trace("publish command response [{}]", (Object)response);
        }
        Span span = this.startSpan("forward Command response", response.getTenantId(), response.getDeviceId(), "child_of", context);
        if (response.getMessagingType() != this.getMessagingType()) {
            span.log(String.format("using messaging type %s instead of type %s used for the original command", this.getMessagingType(), response.getMessagingType()));
        }
        Map<String, Object> properties = this.getMessageProperties(response, tenant, device);
        String topic = PubSubMessageHelper.getTopicName((String)"command_response", (String)response.getTenantId());
        return this.sendAndWaitForOutcome(topic, response.getTenantId(), response.getDeviceId(), response.getPayload(), properties, span).onComplete(ar -> span.finish());
    }

    private Map<String, Object> getMessageProperties(CommandResponse response, TenantObject tenant, RegistrationAssertion device) {
        Map messageProperties = new DownstreamMessageProperties("command_response", tenant.getDefaults().getMap(), device.getDefaults(), response.getAdditionalProperties(), tenant.getResourceLimits()).asMap();
        messageProperties.put("correlation-id", response.getCorrelationId());
        messageProperties.put("status", response.getStatus());
        messageProperties.put("tenant_id", response.getTenantId());
        messageProperties.put("device_id", response.getDeviceId());
        if (response.getContentType() != null) {
            messageProperties.put("content-type", response.getContentType());
        } else if (response.getPayload() != null) {
            messageProperties.put("content-type", "application/octet-stream");
        }
        return messageProperties;
    }
}

