/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.pubsub;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.command.AbstractCommandContext;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.command.CommandAlreadyProcessedException;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.client.command.CommandToBeReprocessedException;
import org.eclipse.hono.client.command.pubsub.PubSubBasedCommand;
import org.eclipse.hono.client.pubsub.PubSubMessageHelper;
import org.eclipse.hono.client.util.StatusCodeMapper;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.MessagingType;

public class PubSubBasedCommandContext
extends AbstractCommandContext<PubSubBasedCommand>
implements CommandContext {
    public PubSubBasedCommandContext(PubSubBasedCommand command, CommandResponseSender commandResponseSender, Span span) {
        super(span, (Command)command, commandResponseSender);
    }

    public void release(Throwable error) {
        Objects.requireNonNull(error);
        if (!this.setCompleted("released")) {
            return;
        }
        Span span = this.getTracingSpan();
        TracingHelper.logError((Span)span, (String)"command could not be delivered or processed", (Throwable)error);
        ServiceInvocationException mappedError = StatusCodeMapper.toServerError((Throwable)error);
        int status = mappedError.getErrorCode();
        Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
        if (this.isRequestResponseCommand() && !(error instanceof CommandAlreadyProcessedException) && !(error instanceof CommandToBeReprocessedException)) {
            String errorMessage = Optional.ofNullable(ServiceInvocationException.getErrorMessageForExternalClient((Throwable)mappedError)).orElse("Temporarily unavailable");
            String correlationId = this.getCorrelationId();
            this.sendDeliveryFailureCommandResponseMessage(status, errorMessage, span, error, correlationId, MessagingType.pubsub).onComplete(v -> span.finish());
        } else {
            span.finish();
        }
    }

    public void modify(boolean deliveryFailed, boolean undeliverableHere) {
        if (!this.setCompleted("modified")) {
            return;
        }
        String deliveryFailedReason = deliveryFailed ? "; delivery failed" : "";
        String undeliverableHereReason = undeliverableHere ? "; undeliverable here" : "";
        int status = undeliverableHere ? 404 : 503;
        Span span = this.getTracingSpan();
        TracingHelper.logError((Span)span, (String)String.format("command for device handled with outcome 'modified' %s %s", deliveryFailedReason, undeliverableHereReason));
        Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
        if (this.isRequestResponseCommand()) {
            String error = String.format("command not processed %s %s", deliveryFailedReason, undeliverableHereReason);
            String correlationId = this.getCorrelationId();
            this.sendDeliveryFailureCommandResponseMessage(status, error, span, null, correlationId, MessagingType.pubsub).onComplete(v -> span.finish());
        } else {
            span.finish();
        }
    }

    public void reject(Throwable error) {
        int n;
        if (!this.setCompleted("rejected")) {
            return;
        }
        if (error instanceof ClientErrorException) {
            ClientErrorException clientErrorException = (ClientErrorException)error;
            n = clientErrorException.getErrorCode();
        } else {
            n = 400;
        }
        int status = n;
        TracingHelper.logError((Span)this.getTracingSpan(), (String)"client error trying to deliver or process command", (Throwable)error);
        Span span = this.getTracingSpan();
        Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
        if (this.isRequestResponseCommand()) {
            String nonNullCause = Optional.ofNullable(error.getMessage()).orElse("Command message rejected");
            String correlationId = this.getCorrelationId();
            this.sendDeliveryFailureCommandResponseMessage(status, nonNullCause, span, null, correlationId, MessagingType.pubsub).onComplete(v -> span.finish());
        } else {
            span.finish();
        }
    }

    private String getCorrelationId() {
        return PubSubMessageHelper.getCorrelationId((Map)((PubSubBasedCommand)this.getCommand()).getPubsubMessage().getAttributesMap()).orElse(null);
    }
}

