/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.pubsub;

import com.google.pubsub.v1.PubsubMessage;
import io.opentracing.Span;
import io.vertx.core.buffer.Buffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.command.Commands;
import org.eclipse.hono.client.pubsub.PubSubMessageHelper;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.MessagingType;

public final class PubSubBasedCommand
implements Command {
    private final Optional<String> validationError;
    private final PubsubMessage pubsubMessage;
    private final String tenantId;
    private final String deviceId;
    private final String correlationId;
    private final String subject;
    private final String contentType;
    private final String requestId;
    private final boolean responseRequired;
    private String gatewayId;

    private PubSubBasedCommand(Optional<String> validationError, PubsubMessage pubsubMessage, String tenantId, String deviceId, String correlationId, String subject, String contentType, boolean responseRequired) {
        this.validationError = validationError;
        this.pubsubMessage = pubsubMessage;
        this.tenantId = Objects.requireNonNull(tenantId);
        this.deviceId = Objects.requireNonNull(deviceId);
        this.correlationId = correlationId;
        this.subject = subject;
        this.contentType = contentType;
        this.responseRequired = responseRequired;
        this.requestId = Commands.encodeRequestIdParameters((String)correlationId, (MessagingType)MessagingType.pubsub);
    }

    public static PubSubBasedCommand fromRoutedCommandMessage(PubsubMessage pubsubMessage) {
        Objects.requireNonNull(pubsubMessage);
        String tenantId = PubSubMessageHelper.getTenantId((Map)pubsubMessage.getAttributesMap()).filter(id -> !id.isEmpty()).orElseThrow(() -> new IllegalArgumentException("Tenant ID is not set"));
        PubSubBasedCommand command = PubSubBasedCommand.getCommand(pubsubMessage, tenantId);
        PubSubMessageHelper.getVia((Map)pubsubMessage.getAttributesMap()).filter(id -> !id.isEmpty()).ifPresent(command::setGatewayId);
        return command;
    }

    public static PubSubBasedCommand from(PubsubMessage pubsubMessage, String tenantId) {
        Objects.requireNonNull(pubsubMessage);
        return PubSubBasedCommand.getCommand(pubsubMessage, tenantId);
    }

    private static PubSubBasedCommand getCommand(PubsubMessage pubsubMessage, String tenantId) {
        Map attributes = pubsubMessage.getAttributesMap();
        if (attributes.isEmpty()) {
            throw new IllegalArgumentException("attributes not set");
        }
        String deviceId = PubSubMessageHelper.getDeviceId((Map)attributes).filter(id -> !id.isEmpty()).orElseThrow(() -> new IllegalArgumentException("device ID is not set"));
        StringJoiner validationErrorJoiner = new StringJoiner(", ");
        boolean responseRequired = PubSubMessageHelper.isResponseRequired((Map)attributes);
        String correlationId = PubSubMessageHelper.getCorrelationId((Map)attributes).filter(id -> !id.isEmpty()).orElseGet(() -> {
            if (responseRequired) {
                validationErrorJoiner.add("correlation-id is not set");
            }
            return null;
        });
        String subject = PubSubMessageHelper.getSubject((Map)attributes).orElseGet(() -> {
            validationErrorJoiner.add("subject not set");
            return null;
        });
        String contentType = PubSubMessageHelper.getContentType((Map)attributes).orElse(null);
        return new PubSubBasedCommand(validationErrorJoiner.length() > 0 ? Optional.of(validationErrorJoiner.toString()) : Optional.empty(), pubsubMessage, tenantId, deviceId, correlationId, subject, contentType, responseRequired);
    }

    public PubsubMessage getPubsubMessage() {
        return this.pubsubMessage;
    }

    public boolean isOneWay() {
        return !this.responseRequired;
    }

    public boolean isValid() {
        return this.validationError.isEmpty();
    }

    public String getInvalidCommandReason() {
        if (this.validationError.isEmpty()) {
            throw new IllegalStateException("command is valid");
        }
        return this.validationError.get();
    }

    public String getTenant() {
        return this.tenantId;
    }

    public String getGatewayOrDeviceId() {
        return Optional.ofNullable(this.gatewayId).orElse(this.deviceId);
    }

    public boolean isTargetedAtGateway() {
        return this.gatewayId != null;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public String getName() {
        this.requireValid();
        return this.subject;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Buffer getPayload() {
        byte[] bytePayload = PubSubMessageHelper.getPayload((PubsubMessage)this.pubsubMessage);
        return Buffer.buffer((byte[])bytePayload);
    }

    public int getPayloadSize() {
        byte[] bytePayload = PubSubMessageHelper.getPayload((PubsubMessage)this.pubsubMessage);
        return Optional.ofNullable(bytePayload).map(bytes -> ((byte[])bytes).length).orElse(0);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getReplyToId() {
        return null;
    }

    public String getCorrelationId() {
        this.requireValid();
        return this.correlationId;
    }

    public MessagingType getMessagingType() {
        return MessagingType.pubsub;
    }

    public String toString() {
        if (this.isValid()) {
            if (this.isTargetedAtGateway()) {
                return String.format("Command [name: %s, tenant-id: %s, gateway-id: %s, device-id: %s, request-id: %s]", this.subject, this.tenantId, this.gatewayId, this.deviceId, this.requestId);
            }
            return String.format("Command [name: %s, tenant-id: %s, device-id: %s, request-id: %s]", this.subject, this.tenantId, this.deviceId, this.requestId);
        }
        return String.format("Invalid Command [tenant-id: %s, device-id: %s. error: %s]", this.tenantId, this.deviceId, this.validationError.get());
    }

    public void logToSpan(Span span) {
        Objects.requireNonNull(span);
        if (this.isValid()) {
            TracingHelper.TAG_CORRELATION_ID.set(span, this.correlationId);
            HashMap<String, String> items = new HashMap<String, String>(3);
            items.put("event", "received command message via Pub/Sub");
            items.put("subject", this.subject);
            items.put("content-type", this.contentType);
            span.log(items);
        } else {
            TracingHelper.logError((Span)span, (String)("received invalid command message [" + this + "]"));
        }
    }

    public Map<String, String> getDeliveryFailureNotificationProperties() {
        return PubSubMessageHelper.getDeliveryFailureNotificationMetadata((Map)this.pubsubMessage.getAttributesMap());
    }

    private void requireValid() {
        if (!this.isValid()) {
            throw new IllegalStateException("command is invalid");
        }
    }
}

