/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.kafka;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.command.AbstractCommandContext;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.command.CommandAlreadyProcessedException;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.client.command.CommandToBeReprocessedException;
import org.eclipse.hono.client.command.kafka.KafkaBasedCommand;
import org.eclipse.hono.client.kafka.KafkaRecordHelper;
import org.eclipse.hono.client.util.StatusCodeMapper;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.MessagingType;

public class KafkaBasedCommandContext
extends AbstractCommandContext<KafkaBasedCommand>
implements CommandContext {
    private static final String PROPERTY_NAME_DELIVERY_FAILURE_RESPONSES_DISABLED = "HONO_DISABLE_KAFKA_COMMAND_DELIVERY_FAILURE_RESPONSES";
    private static final boolean DELIVERY_FAILURE_RESPONSES_DISABLED = Boolean.parseBoolean(KafkaBasedCommandContext.getProperty("HONO_DISABLE_KAFKA_COMMAND_DELIVERY_FAILURE_RESPONSES"));

    public KafkaBasedCommandContext(KafkaBasedCommand command, CommandResponseSender commandResponseSender, Span span) {
        super(span, (Command)command, commandResponseSender);
    }

    public final void release(Throwable error) {
        Objects.requireNonNull(error);
        if (!this.setCompleted("released")) {
            return;
        }
        Span span = this.getTracingSpan();
        TracingHelper.logError((Span)span, (String)"command could not be delivered or processed", (Throwable)error);
        ServiceInvocationException mappedError = StatusCodeMapper.toServerError((Throwable)error);
        int status = mappedError.getErrorCode();
        Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
        if (!DELIVERY_FAILURE_RESPONSES_DISABLED && this.isRequestResponseCommand() && !(error instanceof CommandAlreadyProcessedException) && !(error instanceof CommandToBeReprocessedException)) {
            String errorMessage = Optional.ofNullable(ServiceInvocationException.getErrorMessageForExternalClient((Throwable)mappedError)).orElse("Temporarily unavailable");
            String correlationId = this.getCorrelationId();
            this.sendDeliveryFailureCommandResponseMessage(status, errorMessage, span, error, correlationId, MessagingType.kafka).onComplete(v -> span.finish());
        } else {
            span.finish();
        }
    }

    public final void modify(boolean deliveryFailed, boolean undeliverableHere) {
        if (!this.setCompleted("modified")) {
            return;
        }
        Span span = this.getTracingSpan();
        TracingHelper.logError((Span)span, (String)("command for device handled with outcome 'modified'" + (deliveryFailed ? "; delivery failed" : "") + (undeliverableHere ? "; undeliverable here" : "")));
        int status = undeliverableHere ? 404 : 503;
        Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
        if (!DELIVERY_FAILURE_RESPONSES_DISABLED && this.isRequestResponseCommand()) {
            String error = "command not processed" + (deliveryFailed ? "; delivery failed" : "") + (undeliverableHere ? "; undeliverable here" : "");
            String correlationId = this.getCorrelationId();
            this.sendDeliveryFailureCommandResponseMessage(status, error, span, null, correlationId, MessagingType.kafka).onComplete(v -> span.finish());
        } else {
            span.finish();
        }
    }

    public final void reject(String error) {
        TracingHelper.logError((Span)this.getTracingSpan(), (String)("client error trying to deliver or process command: " + error));
        this.reject(400, error);
    }

    public final void reject(Throwable error) {
        int status = error instanceof ClientErrorException ? ((ClientErrorException)error).getErrorCode() : 400;
        TracingHelper.logError((Span)this.getTracingSpan(), (String)"client error trying to deliver or process command", (Throwable)error);
        this.reject(status, error.getMessage());
    }

    private void reject(int status, String cause) {
        if (!this.setCompleted("rejected")) {
            return;
        }
        Span span = this.getTracingSpan();
        Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
        if (!DELIVERY_FAILURE_RESPONSES_DISABLED && this.isRequestResponseCommand()) {
            String nonNullCause = Optional.ofNullable(cause).orElse("Command message rejected");
            String correlationId = this.getCorrelationId();
            this.sendDeliveryFailureCommandResponseMessage(status, nonNullCause, span, null, correlationId, MessagingType.kafka).onComplete(v -> span.finish());
        } else {
            span.finish();
        }
    }

    private String getCorrelationId() {
        return KafkaRecordHelper.getCorrelationId((List)((KafkaBasedCommand)this.getCommand()).getRecord().headers()).orElse(null);
    }

    private static String getProperty(String name) {
        return System.getProperty(name, System.getenv(name));
    }

    static {
        if (DELIVERY_FAILURE_RESPONSES_DISABLED) {
            LOG.info("sending of command delivery failure response messages is disabled");
        }
    }
}

