/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.kafka;

import io.opentracing.Span;
import io.vertx.core.buffer.Buffer;
import io.vertx.kafka.client.consumer.KafkaConsumerRecord;
import io.vertx.kafka.client.producer.KafkaHeader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.command.Commands;
import org.eclipse.hono.client.kafka.HonoTopic;
import org.eclipse.hono.client.kafka.KafkaRecordHelper;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaBasedCommand
implements Command {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaBasedCommand.class);
    private final Optional<String> validationError;
    private final KafkaConsumerRecord<String, Buffer> record;
    private final String tenantId;
    private final String deviceId;
    private final String correlationId;
    private final String subject;
    private final String contentType;
    private final String requestId;
    private final boolean responseRequired;
    private String gatewayId;

    private KafkaBasedCommand(Optional<String> validationError, KafkaConsumerRecord<String, Buffer> commandRecord, String tenantId, String deviceId, String correlationId, String subject, String contentType, boolean responseRequired) {
        this.validationError = validationError;
        this.record = commandRecord;
        this.tenantId = Objects.requireNonNull(tenantId);
        this.deviceId = Objects.requireNonNull(deviceId);
        this.correlationId = correlationId;
        this.subject = subject;
        this.contentType = contentType;
        this.responseRequired = responseRequired;
        this.requestId = Commands.encodeRequestIdParameters((String)correlationId, (MessagingType)MessagingType.kafka);
    }

    public static KafkaBasedCommand from(KafkaConsumerRecord<String, Buffer> record) {
        Objects.requireNonNull(record);
        if (Strings.isNullOrEmpty((Object)record.topic())) {
            throw new IllegalArgumentException("topic is not set");
        }
        HonoTopic honoTopic = HonoTopic.fromString((String)record.topic());
        if (honoTopic == null || !honoTopic.getType().equals((Object)HonoTopic.Type.COMMAND)) {
            throw new IllegalArgumentException("unsupported topic");
        }
        String tenantId = honoTopic.getTenantId();
        return KafkaBasedCommand.from(record, tenantId);
    }

    public static KafkaBasedCommand fromRoutedCommandRecord(KafkaConsumerRecord<String, Buffer> record) {
        Objects.requireNonNull(record);
        String tenantId = KafkaRecordHelper.getTenantId((List)record.headers()).filter(id -> !id.isEmpty()).orElseThrow(() -> new IllegalArgumentException("tenant is not set"));
        KafkaBasedCommand command = KafkaBasedCommand.from(record, tenantId);
        KafkaRecordHelper.getViaHeader((List)record.headers()).filter(id -> !id.isEmpty()).ifPresent(command::setGatewayId);
        return command;
    }

    private static KafkaBasedCommand from(KafkaConsumerRecord<String, Buffer> record, String tenantId) {
        String deviceId = KafkaRecordHelper.getDeviceId((List)record.headers()).filter(id -> !id.isEmpty()).orElseThrow(() -> new IllegalArgumentException("device identifier is not set"));
        if (!deviceId.equals(record.key())) {
            throw new IllegalArgumentException("device identifier not set as record key");
        }
        StringJoiner validationErrorJoiner = new StringJoiner(", ");
        String subject = KafkaRecordHelper.getSubject((List)record.headers()).orElseGet(() -> {
            validationErrorJoiner.add("subject not set");
            return null;
        });
        String contentType = KafkaRecordHelper.getContentType((List)record.headers()).orElse(null);
        boolean responseRequired = KafkaRecordHelper.isResponseRequired((List)record.headers());
        String correlationId = KafkaRecordHelper.getCorrelationId((List)record.headers()).filter(id -> !id.isEmpty()).orElseGet(() -> {
            if (responseRequired) {
                validationErrorJoiner.add("correlation-id is not set");
            }
            return null;
        });
        return new KafkaBasedCommand(validationErrorJoiner.length() > 0 ? Optional.of(validationErrorJoiner.toString()) : Optional.empty(), record, tenantId, deviceId, correlationId, subject, contentType, responseRequired);
    }

    public Map<String, String> getDeliveryFailureNotificationProperties() {
        return this.record.headers().stream().filter(header -> header.key().startsWith("delivery-failure-notification-metadata")).collect(Collectors.toMap(KafkaHeader::key, header -> header.value().toString(), (v1, v2) -> {
            LOG.debug("ignoring duplicate delivery notification header with value [{}] for {}", v2, (Object)this);
            return v1;
        }));
    }

    public MessagingType getMessagingType() {
        return MessagingType.kafka;
    }

    public boolean isOneWay() {
        return !this.responseRequired;
    }

    public boolean isValid() {
        return !this.validationError.isPresent();
    }

    public String getInvalidCommandReason() {
        if (!this.validationError.isPresent()) {
            throw new IllegalStateException("command is valid");
        }
        return this.validationError.get();
    }

    public String getTenant() {
        return this.tenantId;
    }

    public String getGatewayOrDeviceId() {
        return Optional.ofNullable(this.gatewayId).orElse(this.deviceId);
    }

    public boolean isTargetedAtGateway() {
        return this.gatewayId != null;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public String getName() {
        this.requireValid();
        return this.subject;
    }

    public String getRequestId() {
        this.requireValid();
        return this.requestId;
    }

    public Buffer getPayload() {
        this.requireValid();
        return (Buffer)this.record.value();
    }

    public int getPayloadSize() {
        return Optional.ofNullable((Buffer)this.record.value()).map(Buffer::length).orElse(0);
    }

    public String getContentType() {
        this.requireValid();
        return this.contentType;
    }

    public String getReplyToId() {
        this.requireValid();
        return null;
    }

    public String getCorrelationId() {
        this.requireValid();
        return this.correlationId;
    }

    public KafkaConsumerRecord<String, Buffer> getRecord() {
        return this.record;
    }

    private void requireValid() {
        if (!this.isValid()) {
            throw new IllegalStateException("command is invalid");
        }
    }

    public String toString() {
        if (this.isValid()) {
            if (this.isTargetedAtGateway()) {
                return String.format("Command [name: %s, tenant-id: %s, gateway-id: %s, device-id: %s, request-id: %s]", this.getName(), this.tenantId, this.gatewayId, this.deviceId, this.requestId);
            }
            return String.format("Command [name: %s, tenant-id: %s, device-id: %s, request-id: %s]", this.getName(), this.tenantId, this.deviceId, this.requestId);
        }
        return String.format("Invalid Command [tenant-id: %s, device-id: %s. error: %s]", this.tenantId, this.deviceId, this.validationError.get());
    }

    public void logToSpan(Span span) {
        Objects.requireNonNull(span);
        if (this.isValid()) {
            TracingHelper.TAG_CORRELATION_ID.set(span, this.correlationId);
            HashMap<String, String> items = new HashMap<String, String>(3);
            items.put("event", "received command message via Kafka");
            items.put("subject", this.subject);
            items.put("content-type", this.contentType);
            span.log(items);
        } else {
            TracingHelper.logError((Span)span, (String)("received invalid command message [" + this + "]"));
        }
    }
}

