/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.kafka;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.command.CommandAlreadyProcessedException;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.CommandResponse;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.client.command.CommandToBeReprocessedException;
import org.eclipse.hono.client.command.kafka.KafkaBasedCommand;
import org.eclipse.hono.client.kafka.KafkaRecordHelper;
import org.eclipse.hono.client.util.StatusCodeMapper;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.MapBasedExecutionContext;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBasedCommandContext
extends MapBasedExecutionContext
implements CommandContext {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaBasedCommandContext.class);
    private final KafkaBasedCommand command;
    private final CommandResponseSender commandResponseSender;
    private String completedOutcome;

    public KafkaBasedCommandContext(KafkaBasedCommand command, CommandResponseSender commandResponseSender, Span span) {
        super(span);
        this.command = Objects.requireNonNull(command);
        this.commandResponseSender = Objects.requireNonNull(commandResponseSender);
    }

    public final boolean isCompleted() {
        return this.completedOutcome != null;
    }

    public final void logCommandToSpan(Span span) {
        this.command.logToSpan(span);
    }

    public final KafkaBasedCommand getCommand() {
        return this.command;
    }

    public final void accept() {
        if (!this.setCompleted("accepted")) {
            return;
        }
        Span span = this.getTracingSpan();
        LOG.trace("accepted command message [{}]", (Object)this.getCommand());
        Tags.HTTP_STATUS.set(span, Integer.valueOf(202));
        span.log("command for device handled with outcome 'accepted'");
        span.finish();
    }

    public final void release(Throwable error) {
        Objects.requireNonNull(error);
        if (!this.setCompleted("released")) {
            return;
        }
        Span span = this.getTracingSpan();
        TracingHelper.logError((Span)span, (String)"command could not be delivered or processed", (Throwable)error);
        ServiceInvocationException mappedError = StatusCodeMapper.toServerError((Throwable)error);
        int status = mappedError.getErrorCode();
        Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
        if (this.isRequestResponseCommand() && !(error instanceof CommandAlreadyProcessedException) && !(error instanceof CommandToBeReprocessedException)) {
            String errorMessage = Optional.ofNullable(ServiceInvocationException.getErrorMessageForExternalClient((Throwable)mappedError)).orElse("Temporarily unavailable");
            this.sendDeliveryFailureCommandResponseMessage(status, errorMessage, span, error).onComplete(v -> span.finish());
        } else {
            span.finish();
        }
    }

    public final void modify(boolean deliveryFailed, boolean undeliverableHere) {
        if (!this.setCompleted("modified")) {
            return;
        }
        Span span = this.getTracingSpan();
        TracingHelper.logError((Span)span, (String)("command for device handled with outcome 'modified'" + (deliveryFailed ? "; delivery failed" : "") + (undeliverableHere ? "; undeliverable here" : "")));
        int status = undeliverableHere ? 404 : 503;
        Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
        if (this.isRequestResponseCommand()) {
            String error = "command not processed" + (deliveryFailed ? "; delivery failed" : "") + (undeliverableHere ? "; undeliverable here" : "");
            this.sendDeliveryFailureCommandResponseMessage(status, error, span, null).onComplete(v -> span.finish());
        } else {
            span.finish();
        }
    }

    public final void reject(String error) {
        TracingHelper.logError((Span)this.getTracingSpan(), (String)("client error trying to deliver or process command: " + error));
        this.reject(400, error);
    }

    public final void reject(Throwable error) {
        int status = error instanceof ClientErrorException ? ((ClientErrorException)error).getErrorCode() : 400;
        TracingHelper.logError((Span)this.getTracingSpan(), (String)"client error trying to deliver or process command", (Throwable)error);
        this.reject(status, error.getMessage());
    }

    private void reject(int status, String cause) {
        if (!this.setCompleted("rejected")) {
            return;
        }
        Span span = this.getTracingSpan();
        Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
        if (this.isRequestResponseCommand()) {
            String nonNullCause = Optional.ofNullable(cause).orElse("Command message rejected");
            this.sendDeliveryFailureCommandResponseMessage(status, nonNullCause, span, null).onComplete(v -> span.finish());
        } else {
            span.finish();
        }
    }

    private boolean isRequestResponseCommand() {
        return !this.command.isOneWay();
    }

    private Future<Void> sendDeliveryFailureCommandResponseMessage(int status, String error, Span span, Throwable cause) {
        JsonObject payloadJson = new JsonObject();
        payloadJson.put("error", (Object)(error != null ? error : ""));
        String correlationId = this.getCorrelationId();
        if (correlationId == null) {
            TracingHelper.logError((Span)span, (String)"can't send command response message - no correlation id set");
            return Future.failedFuture((String)"missing correlation id");
        }
        CommandResponse commandResponse = new CommandResponse(this.command.getTenant(), this.command.getDeviceId(), payloadJson.toBuffer(), "application/vnd.eclipse-hono-delivery-failure-notification+json", status, correlationId, "", MessagingType.kafka);
        commandResponse.setAdditionalProperties(Collections.unmodifiableMap(this.command.getDeliveryFailureNotificationProperties()));
        return this.commandResponseSender.sendCommandResponse(Optional.ofNullable(this.get("tenant-config")).filter(TenantObject.class::isInstance).map(TenantObject.class::cast).orElseGet(() -> TenantObject.from((String)this.command.getTenant())), new RegistrationAssertion(this.command.getDeviceId()), commandResponse, span.context()).onFailure(thr -> {
            LOG.debug("failed to publish command response [{}]", (Object)commandResponse, thr);
            TracingHelper.logError((Span)span, (String)"failed to publish command response message", (Throwable)thr);
        }).onSuccess(v -> {
            LOG.debug("published error command response [{}, cause: {}]", (Object)commandResponse, (Object)(cause != null ? cause.getMessage() : error));
            span.log("published error command response");
        });
    }

    private String getCorrelationId() {
        return KafkaRecordHelper.getCorrelationId((List)this.command.getRecord().headers()).orElse(null);
    }

    private boolean setCompleted(String outcome) {
        if (this.completedOutcome != null) {
            LOG.warn("can't apply '{}' outcome, context already completed with '{}' outcome [{}]", new Object[]{outcome, this.completedOutcome, this.getCommand()});
            return false;
        }
        this.completedOutcome = outcome;
        return true;
    }
}

