/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.amqp;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonHelper;
import java.util.Objects;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.amqp.connection.AmqpUtils;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.amqp.ProtonBasedCommand;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.MapBasedExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtonBasedCommandContext
extends MapBasedExecutionContext
implements CommandContext {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonBasedCommandContext.class);
    private final ProtonBasedCommand command;
    private final ProtonDelivery delivery;
    private String completedOutcome;

    public ProtonBasedCommandContext(ProtonBasedCommand command, ProtonDelivery delivery, Span span) {
        super(span);
        this.command = Objects.requireNonNull(command);
        this.delivery = Objects.requireNonNull(delivery);
    }

    public final boolean isCompleted() {
        return this.completedOutcome != null;
    }

    public void logCommandToSpan(Span span) {
        this.command.logToSpan(span);
    }

    public ProtonBasedCommand getCommand() {
        return this.command;
    }

    public void accept() {
        if (!this.setCompleted("accepted")) {
            return;
        }
        Tags.HTTP_STATUS.set(this.getTracingSpan(), Integer.valueOf(202));
        this.updateDelivery((DeliveryState)Accepted.getInstance());
    }

    public void release() {
        if (!this.setCompleted("released")) {
            return;
        }
        TracingHelper.logError((Span)this.getTracingSpan(), (String)"command could not be delivered or processed");
        Tags.HTTP_STATUS.set(this.getTracingSpan(), Integer.valueOf(503));
        this.updateDelivery((DeliveryState)Released.getInstance());
    }

    public void release(Throwable error) {
        Objects.requireNonNull(error);
        if (!this.setCompleted("released")) {
            return;
        }
        TracingHelper.logError((Span)this.getTracingSpan(), (String)"command could not be delivered or processed", (Throwable)error);
        int status = ServiceInvocationException.extractStatusCode((Throwable)error);
        Tags.HTTP_STATUS.set(this.getTracingSpan(), Integer.valueOf(status));
        this.updateDelivery((DeliveryState)Released.getInstance());
    }

    public void modify(boolean deliveryFailed, boolean undeliverableHere) {
        if (!this.setCompleted("modified")) {
            return;
        }
        Span span = this.getTracingSpan();
        TracingHelper.logError((Span)span, (String)("command for device handled with outcome 'modified'" + (deliveryFailed ? "; delivery failed" : "") + (undeliverableHere ? "; undeliverable here" : "")));
        int status = undeliverableHere ? 404 : 503;
        Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
        Modified modified = new Modified();
        modified.setDeliveryFailed(Boolean.valueOf(deliveryFailed));
        modified.setUndeliverableHere(Boolean.valueOf(undeliverableHere));
        this.updateDelivery((DeliveryState)modified);
    }

    public void reject(String error) {
        if (!this.setCompleted("rejected")) {
            return;
        }
        TracingHelper.logError((Span)this.getTracingSpan(), (String)("client error trying to deliver or process command: " + error));
        Tags.HTTP_STATUS.set(this.getTracingSpan(), Integer.valueOf(400));
        ErrorCondition errorCondition = ProtonHelper.condition((Symbol)AmqpUtils.AMQP_BAD_REQUEST, (String)error);
        Rejected rejected = new Rejected();
        rejected.setError(errorCondition);
        this.updateDelivery((DeliveryState)rejected);
    }

    public void reject(Throwable error) {
        if (!this.setCompleted("rejected")) {
            return;
        }
        TracingHelper.logError((Span)this.getTracingSpan(), (String)"client error trying to deliver or process command", (Throwable)error);
        int status = error instanceof ClientErrorException ? ((ClientErrorException)error).getErrorCode() : 400;
        Tags.HTTP_STATUS.set(this.getTracingSpan(), Integer.valueOf(status));
        this.reject(ServiceInvocationException.getErrorMessageForExternalClient((Throwable)error));
    }

    private void updateDelivery(DeliveryState deliveryState) {
        Span span = this.getTracingSpan();
        if (this.delivery.isSettled()) {
            String msg = String.format("cannot complete incoming delivery of command message with outcome '%s' - delivery already settled locally; local state: %s", deliveryState, this.delivery.getLocalState());
            TracingHelper.logError((Span)this.getTracingSpan(), (String)msg);
            LOG.info("{} [{}]", (Object)msg, (Object)this.getCommand());
        } else {
            boolean wasAlreadyRemotelySettled = this.delivery.remotelySettled();
            this.delivery.disposition(deliveryState, true);
            if (wasAlreadyRemotelySettled) {
                String msg = String.format("cannot complete incoming delivery of command message with outcome '%s' - delivery already settled remotely; remote state: %s", deliveryState, this.delivery.getRemoteState());
                TracingHelper.logError((Span)this.getTracingSpan(), (String)msg);
                LOG.info("{} [{}]", (Object)msg, (Object)this.getCommand());
            } else if (deliveryState instanceof Accepted) {
                LOG.trace("accepted command message [{}]", (Object)this.getCommand());
                span.log("accepted command for device");
            } else if (deliveryState instanceof Released) {
                LOG.debug("released command message [{}]", (Object)this.getCommand());
                TracingHelper.logError((Span)span, (String)"released command for device");
            } else if (deliveryState instanceof Modified) {
                Modified modified = (Modified)deliveryState;
                LOG.debug("modified command message [{}]", (Object)this.getCommand());
                TracingHelper.logError((Span)span, (String)("modified command for device" + (Boolean.TRUE.equals(modified.getDeliveryFailed()) ? "; delivery failed" : "") + (Boolean.TRUE.equals(modified.getUndeliverableHere()) ? "; undeliverable here" : "")));
            } else if (deliveryState instanceof Rejected) {
                Rejected rejected = (Rejected)deliveryState;
                ErrorCondition errorCondition = rejected.getError();
                LOG.debug("rejected command message [error: {}, command: {}]", (Object)errorCondition, (Object)this.getCommand());
                TracingHelper.logError((Span)span, (String)("rejected command for device" + (String)(errorCondition != null && errorCondition.getDescription() != null ? "; error: " + errorCondition.getDescription() : "")));
            } else {
                LOG.warn("unexpected delivery state [{}] when settling command message [{}]", (Object)deliveryState, (Object)this.getCommand());
                TracingHelper.logError((Span)span, (String)("unexpected delivery state: " + deliveryState));
            }
        }
        span.finish();
    }

    private boolean setCompleted(String outcome) {
        if (this.completedOutcome != null) {
            LOG.warn("can't apply '{}' outcome, context already completed with '{}' outcome [{}]", new Object[]{outcome, this.completedOutcome, this.getCommand()});
            return false;
        }
        this.completedOutcome = outcome;
        return true;
    }
}

