/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.amqp;

import io.opentracing.Span;
import io.vertx.core.buffer.Buffer;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.command.Commands;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CommandConstants;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;

public final class ProtonBasedCommand
implements Command {
    private final Optional<String> validationError;
    private final Message message;
    private final String tenantId;
    private final String deviceId;
    private final String correlationId;
    private final String replyToId;
    private final String requestId;
    private String gatewayId;

    private ProtonBasedCommand(Optional<String> validationError, Message message, String tenantId, String deviceId, String correlationId, String replyToId) {
        this.validationError = validationError;
        this.message = message;
        this.tenantId = Objects.requireNonNull(tenantId);
        this.deviceId = Objects.requireNonNull(deviceId);
        this.correlationId = correlationId;
        this.replyToId = replyToId;
        this.requestId = Commands.encodeRequestIdParameters((String)correlationId, (String)replyToId, (String)deviceId, (MessagingType)MessagingType.amqp);
    }

    public static ProtonBasedCommand from(Message message) {
        Objects.requireNonNull(message);
        if (!ResourceIdentifier.isValid((String)message.getAddress())) {
            throw new IllegalArgumentException("address is empty or invalid");
        }
        ResourceIdentifier addressIdentifier = ResourceIdentifier.fromString((String)message.getAddress());
        if (Strings.isNullOrEmpty((Object)addressIdentifier.getTenantId())) {
            throw new IllegalArgumentException("address is missing tenant-id part");
        }
        if (Strings.isNullOrEmpty((Object)addressIdentifier.getResourceId())) {
            throw new IllegalArgumentException("address is missing device-id part");
        }
        String tenantId = addressIdentifier.getTenantId();
        String deviceId = addressIdentifier.getResourceId();
        StringJoiner validationErrorJoiner = new StringJoiner(", ");
        if (message.getSubject() == null) {
            validationErrorJoiner.add("subject not set");
        }
        ProtonBasedCommand.getUnsupportedPayloadReason(message).ifPresent(validationErrorJoiner::add);
        String correlationId = null;
        Object correlationIdObj = MessageHelper.getCorrelationId((Message)message);
        if (correlationIdObj != null) {
            if (correlationIdObj instanceof String) {
                correlationId = (String)correlationIdObj;
            } else {
                validationErrorJoiner.add("message/correlation-id is not of type string, actual type: " + correlationIdObj.getClass().getName());
            }
        } else if (message.getReplyTo() != null) {
            validationErrorJoiner.add("neither message-id nor correlation-id is set");
        }
        String replyToId = null;
        if (message.getReplyTo() != null) {
            try {
                ResourceIdentifier replyTo = ResourceIdentifier.fromString((String)message.getReplyTo());
                if (!CommandConstants.isNorthboundCommandResponseEndpoint((String)replyTo.getEndpoint())) {
                    validationErrorJoiner.add("reply-to not a command address: " + message.getReplyTo());
                } else if (tenantId != null && !tenantId.equals(replyTo.getTenantId())) {
                    validationErrorJoiner.add("reply-to not targeted at tenant " + tenantId + ": " + message.getReplyTo());
                } else {
                    replyToId = replyTo.getPathWithoutBase();
                    if (replyToId.isEmpty()) {
                        validationErrorJoiner.add("reply-to part after tenant not set: " + message.getReplyTo());
                    }
                }
            }
            catch (IllegalArgumentException e) {
                validationErrorJoiner.add("reply-to cannot be parsed: " + message.getReplyTo());
            }
        }
        return new ProtonBasedCommand(validationErrorJoiner.length() > 0 ? Optional.of(validationErrorJoiner.toString()) : Optional.empty(), message, tenantId, deviceId, correlationId, replyToId);
    }

    public static ProtonBasedCommand fromRoutedCommandMessage(Message message) {
        ProtonBasedCommand command = ProtonBasedCommand.from(message);
        String gatewayId = (String)MessageHelper.getApplicationProperty((ApplicationProperties)message.getApplicationProperties(), (String)"via", String.class);
        if (!Strings.isNullOrEmpty((Object)gatewayId)) {
            command.setGatewayId(gatewayId);
        }
        return command;
    }

    Message getMessage() {
        return this.message;
    }

    public MessagingType getMessagingType() {
        return MessagingType.amqp;
    }

    public boolean isOneWay() {
        return this.replyToId == null;
    }

    public boolean isValid() {
        return !this.validationError.isPresent();
    }

    public String getInvalidCommandReason() {
        if (!this.validationError.isPresent()) {
            throw new IllegalStateException("command is valid");
        }
        return this.validationError.get();
    }

    public String getTenant() {
        return this.tenantId;
    }

    public String getGatewayOrDeviceId() {
        return Optional.ofNullable(this.gatewayId).orElse(this.deviceId);
    }

    public boolean isTargetedAtGateway() {
        return this.gatewayId != null;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public String getName() {
        this.requireValid();
        return this.message.getSubject();
    }

    public String getRequestId() {
        this.requireValid();
        return this.requestId;
    }

    public Buffer getPayload() {
        this.requireValid();
        return MessageHelper.getPayload((Message)this.message);
    }

    public int getPayloadSize() {
        return MessageHelper.getPayloadSize((Message)this.message);
    }

    public String getContentType() {
        this.requireValid();
        return this.message.getContentType();
    }

    public String getReplyToId() {
        this.requireValid();
        return this.replyToId;
    }

    public String getCorrelationId() {
        this.requireValid();
        return this.correlationId;
    }

    private void requireValid() {
        if (!this.isValid()) {
            throw new IllegalStateException("command is invalid");
        }
    }

    public String toString() {
        if (this.isValid()) {
            if (this.isTargetedAtGateway()) {
                return String.format("Command [name: %s, tenant-id: %s, gateway-id: %s, device-id: %s, request-id: %s]", this.getName(), this.tenantId, this.gatewayId, this.deviceId, this.requestId);
            }
            return String.format("Command [name: %s, tenant-id: %s, device-id: %s, request-id: %s]", this.getName(), this.tenantId, this.deviceId, this.requestId);
        }
        return String.format("Invalid Command [tenant-id: %s, device-id: %s. error: %s]", this.tenantId, this.deviceId, this.validationError.get());
    }

    public void logToSpan(Span span) {
        Objects.requireNonNull(span);
        if (this.isValid()) {
            TracingHelper.TAG_CORRELATION_ID.set(span, this.getCorrelationId());
            HashMap<String, String> items = new HashMap<String, String>(5);
            items.put("event", "received command message via AMQP");
            items.put("to", this.message.getAddress());
            items.put("reply-to", this.message.getReplyTo());
            items.put("name", this.getName());
            items.put("content-type", this.getContentType());
            span.log(items);
        } else {
            TracingHelper.logError((Span)span, (String)("received invalid command message [" + this + "]"));
        }
    }

    private static Optional<String> getUnsupportedPayloadReason(Message msg) {
        Objects.requireNonNull(msg);
        String reason = null;
        if (msg.getBody() instanceof AmqpValue) {
            Object value = ((AmqpValue)msg.getBody()).getValue();
            if (value == null) {
                reason = "message has body with empty amqp-value section";
            } else if (!(value instanceof byte[]) && !(value instanceof String)) {
                reason = String.format("message has amqp-value section body with unsupported value type [%s], supported is byte[] or String", value.getClass().getName());
            }
        } else if (msg.getBody() != null && !(msg.getBody() instanceof Data)) {
            reason = String.format("message has unsupported body section [%s], supported section types are 'data' and 'amqp-value'", msg.getBody().getClass().getName());
        }
        return Optional.ofNullable(reason);
    }
}

