/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.amqp;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.vertx.proton.ProtonHelper;
import java.util.Objects;
import org.apache.qpid.proton.amqp.Symbol;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.amqp.ProtonBasedLegacyCommandWrapper;
import org.eclipse.hono.util.Constants;

public class ProtonBasedLegacyCommandContextWrapper
implements CommandContext {
    private final org.eclipse.hono.client.CommandContext ctx;
    private final Command command;

    public ProtonBasedLegacyCommandContextWrapper(org.eclipse.hono.client.CommandContext context) {
        this.ctx = Objects.requireNonNull(context);
        this.command = new ProtonBasedLegacyCommandWrapper(context.getCommand());
    }

    public void logCommandToSpan(Span span) {
        this.command.logToSpan(span);
    }

    public Command getCommand() {
        return this.command;
    }

    public void accept() {
        this.ctx.accept();
    }

    public void release() {
        this.ctx.release();
    }

    public void release(Throwable error) {
        Objects.requireNonNull(error);
        this.ctx.release();
    }

    public void modify(boolean deliveryFailed, boolean undeliverableHere) {
        this.ctx.modify(deliveryFailed, undeliverableHere);
    }

    public void reject(String cause) {
        this.ctx.reject(ProtonHelper.condition((Symbol)Constants.AMQP_BAD_REQUEST, (String)cause));
    }

    public void reject(Throwable error) {
        this.reject(ServiceInvocationException.getErrorMessageForExternalClient((Throwable)error));
    }

    public <T> T get(String key) {
        return (T)this.ctx.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        return (T)this.ctx.get(key, defaultValue);
    }

    public void put(String key, Object value) {
        this.ctx.put(key, value);
    }

    public SpanContext getTracingContext() {
        return this.ctx.getTracingContext();
    }

    public Span getTracingSpan() {
        return this.ctx.getTracingSpan();
    }
}

