/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.amqp;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.proton.ProtonHelper;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.SendMessageSampler;
import org.eclipse.hono.client.StatusCodeMapper;
import org.eclipse.hono.client.amqp.AbstractServiceClient;
import org.eclipse.hono.client.amqp.GenericSenderLink;
import org.eclipse.hono.client.command.CommandResponse;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.util.AddressHelper;
import org.eclipse.hono.util.MessageHelper;

public class ProtonBasedCommandResponseSender
extends AbstractServiceClient
implements CommandResponseSender {
    private final boolean jmsVendorPropsEnabled;

    public ProtonBasedCommandResponseSender(HonoConnection connection, SendMessageSampler.Factory samplerFactory, boolean jmsVendorPropsEnabled) {
        super(connection, samplerFactory);
        this.jmsVendorPropsEnabled = jmsVendorPropsEnabled;
    }

    private Future<GenericSenderLink> createSender(String tenantId, String replyId) {
        return this.connection.executeOnContext(result -> GenericSenderLink.create((HonoConnection)this.connection, (String)"command_response", (String)tenantId, (String)replyId, (SendMessageSampler)this.samplerFactory.create("command_response"), onRemoteClose -> {}).onComplete((Handler)result));
    }

    private Message createDownstreamMessage(CommandResponse response, Map<String, Object> properties) {
        Message msg = ProtonHelper.message();
        MessageHelper.setApplicationProperties((Message)msg, properties);
        MessageHelper.setCreationTime((Message)msg);
        msg.setCorrelationId((Object)response.getCorrelationId());
        MessageHelper.setPayload((Message)msg, (String)response.getContentType(), (Buffer)response.getPayload());
        MessageHelper.addStatus((Message)msg, (int)response.getStatus());
        msg.setAddress(AddressHelper.getTargetAddress((String)"command_response", (String)response.getTenantId(), (String)response.getReplyToId(), null));
        MessageHelper.addTenantId((Message)msg, (String)response.getTenantId());
        MessageHelper.addDeviceId((Message)msg, (String)response.getDeviceId());
        if (this.jmsVendorPropsEnabled) {
            MessageHelper.addJmsVendorProperties((Message)msg);
        }
        return msg;
    }

    public Future<Void> sendCommandResponse(CommandResponse response, SpanContext context) {
        Objects.requireNonNull(response);
        return this.createSender(response.getTenantId(), response.getReplyToId()).recover(thr -> Future.failedFuture((Throwable)StatusCodeMapper.toServerError((Throwable)thr))).compose(sender -> {
            Message msg = this.createDownstreamMessage(response, response.getAdditionalProperties());
            Span span = this.newChildSpan(context, "forward Command response");
            if (response.getMessagingType() != this.getMessagingType()) {
                span.log(String.format("using messaging type %s instead of type %s used for the original command", this.getMessagingType(), response.getMessagingType()));
            }
            return sender.sendAndWaitForOutcome(msg, span).onComplete(delivery -> sender.close());
        }).mapEmpty();
    }
}

