/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.application.client.kafka.impl;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.application.client.CommandSender;
import org.eclipse.hono.client.kafka.HonoTopic;
import org.eclipse.hono.client.kafka.KafkaProducerConfigProperties;
import org.eclipse.hono.client.kafka.KafkaProducerFactory;
import org.eclipse.hono.client.kafka.producer.AbstractKafkaBasedMessageSender;
import org.eclipse.hono.util.BufferResult;

public class KafkaBasedCommandSender
extends AbstractKafkaBasedMessageSender
implements CommandSender {
    public KafkaBasedCommandSender(KafkaProducerFactory<String, Buffer> producerFactory, KafkaProducerConfigProperties config, Tracer tracer) {
        super(producerFactory, "command-sender", config, tracer);
    }

    public Future<Void> sendAsyncCommand(String tenantId, String deviceId, String command, String contentType, Buffer data, String correlationId, String replyId, Map<String, Object> properties, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(command);
        Objects.requireNonNull(correlationId);
        return this.sendCommand(tenantId, deviceId, command, contentType, data, correlationId, properties, true, context);
    }

    public Future<Void> sendOneWayCommand(String tenantId, String deviceId, String command, String contentType, Buffer data, Map<String, Object> properties, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(command);
        return this.sendCommand(tenantId, deviceId, command, contentType, data, null, properties, false, context);
    }

    public Future<BufferResult> sendCommand(String tenantId, String deviceId, String command, String contentType, Buffer data, String replyId, Map<String, Object> properties, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(command);
        return null;
    }

    private Future<Void> sendCommand(String tenantId, String deviceId, String command, String contentType, Buffer data, String correlationId, Map<String, Object> properties, boolean responseRequired, SpanContext context) {
        HonoTopic topic = new HonoTopic(HonoTopic.Type.COMMAND, tenantId);
        Map<String, Object> headerProperties = this.getHeaderProperties(deviceId, command, contentType, correlationId, responseRequired, properties);
        return this.sendAndWaitForOutcome(topic.toString(), tenantId, deviceId, data, headerProperties, context);
    }

    private Map<String, Object> getHeaderProperties(String deviceId, String subject, String contentType, String correlationId, boolean responseRequired, Map<String, Object> properties) {
        Map props = Optional.ofNullable(properties).map(HashMap::new).orElseGet(HashMap::new);
        props.put("device_id", deviceId);
        props.put("subject", subject);
        props.put("content-type", Objects.nonNull(contentType) ? contentType : "application/octet-stream");
        Optional.ofNullable(correlationId).ifPresent(id -> props.put("correlation-id", id));
        props.put("response-required", responseRequired);
        return props;
    }
}

