/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.tracing;

import io.opentracing.propagation.TextMap;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.amqp.tracing.MessageAnnotationsExtractAdapter;

public final class AmqpMessageExtractAdapter
implements TextMap {
    private final Message message;
    private final MessageAnnotationsExtractAdapter legacyAdapter;

    public AmqpMessageExtractAdapter(Message message) {
        this(message, null);
    }

    public AmqpMessageExtractAdapter(Message message, String legacyMessageAnnotationsPropertiesMapName) {
        this.message = Objects.requireNonNull(message);
        this.legacyAdapter = Optional.ofNullable(legacyMessageAnnotationsPropertiesMapName).map(mapName -> new MessageAnnotationsExtractAdapter(message, (String)mapName)).orElse(null);
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        Map<?, ?> legacyPropertiesMap;
        if (this.legacyAdapter != null && !(legacyPropertiesMap = this.legacyAdapter.getMessageAnnotationsPropertiesMap()).isEmpty()) {
            return AmqpMessageExtractAdapter.mapEntriesIterator(legacyPropertiesMap.entrySet().iterator());
        }
        ApplicationProperties applicationProperties = this.message.getApplicationProperties();
        if (applicationProperties == null || applicationProperties.getValue() == null) {
            return Collections.emptyIterator();
        }
        return AmqpMessageExtractAdapter.mapEntriesIterator(applicationProperties.getValue().entrySet().iterator());
    }

    private static Iterator<Map.Entry<String, String>> mapEntriesIterator(final Iterator<? extends Map.Entry<?, ?>> entriesIterator) {
        return new Iterator<Map.Entry<String, String>>(){

            @Override
            public boolean hasNext() {
                return entriesIterator.hasNext();
            }

            @Override
            public Map.Entry<String, String> next() {
                Map.Entry nextEntry = (Map.Entry)entriesIterator.next();
                return new AbstractMap.SimpleEntry<String, String>(nextEntry.getKey().toString(), nextEntry.getValue().toString());
            }
        };
    }

    public void put(String key, String value) {
        throw new UnsupportedOperationException();
    }
}

