/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.connection;

import io.vertx.proton.ProtonConnection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.engine.Record;
import org.eclipse.hono.auth.Activity;
import org.eclipse.hono.auth.Authorities;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.auth.HonoUserAdapter;
import org.eclipse.hono.util.ResourceIdentifier;

public final class AmqpConstants {
    public static final Symbol AMQP_BAD_REQUEST = Symbol.valueOf((String)"hono:bad-request");
    public static final Symbol AMQP_ERROR_INACTIVITY = Symbol.valueOf((String)"hono:inactivity");
    public static final Symbol CAP_ANONYMOUS_RELAY = Symbol.valueOf((String)"ANONYMOUS-RELAY");
    public static final String KEY_CLIENT_PRINCIPAL = "CLIENT_PRINCIPAL";
    public static final String SUBJECT_ANONYMOUS = "ANONYMOUS";
    public static final HonoUser PRINCIPAL_ANONYMOUS = new HonoUserAdapter(){
        private final Authorities authorities = new Authorities(){

            public Map<String, Object> asMap() {
                return Collections.emptyMap();
            }

            public boolean isAuthorized(ResourceIdentifier resourceId, Activity intent) {
                return false;
            }

            public boolean isAuthorized(ResourceIdentifier resourceId, String operation) {
                return false;
            }
        };

        public String getName() {
            return AmqpConstants.SUBJECT_ANONYMOUS;
        }

        public Authorities getAuthorities() {
            return this.authorities;
        }
    };

    private AmqpConstants() {
    }

    private static HonoUser getClientPrincipal(Record record) {
        if (record != null) {
            HonoUser client = (HonoUser)record.get((Object)KEY_CLIENT_PRINCIPAL, HonoUser.class);
            return client != null ? client : PRINCIPAL_ANONYMOUS;
        }
        return PRINCIPAL_ANONYMOUS;
    }

    public static HonoUser getClientPrincipal(ProtonConnection con) {
        Record attachments = Objects.requireNonNull(con).attachments();
        return AmqpConstants.getClientPrincipal(attachments);
    }

    public static void setClientPrincipal(ProtonConnection con, HonoUser principal) {
        Objects.requireNonNull(principal);
        Record attachments = Objects.requireNonNull(con).attachments();
        attachments.set((Object)KEY_CLIENT_PRINCIPAL, HonoUser.class, (Object)principal);
    }
}

